/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block.entity;

import de.cristelknight.doapi.common.registry.DoApiBlockEntityTypes;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class FlowerBoxBlockEntity
extends BlockEntity {
    private NonNullList<ItemStack> flowers = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);

    public FlowerBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DoApiBlockEntityTypes.FLOWER_BOX_ENTITY.get(), pos, state);
    }

    public void m_183515_(CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.flowers);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.flowers = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.flowers);
    }

    public void addFlower(ItemStack stack, int slot) {
        this.flowers.set(slot, (Object)stack);
        this.m_6596_();
    }

    public ItemStack removeFlower(int slot) {
        ItemStack stack = (ItemStack)this.flowers.set(slot, (Object)ItemStack.f_41583_);
        this.m_6596_();
        return stack;
    }

    public ItemStack getFlower(int slot) {
        return (ItemStack)this.flowers.get(slot);
    }

    public boolean isSlotEmpty(int slot) {
        return slot < this.flowers.size() && ((ItemStack)this.flowers.get(slot)).m_41619_();
    }

    public Item[] getFlowers() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (ItemStack stack : this.flowers) {
            if (stack.m_41619_()) continue;
            items.add(stack.m_41720_());
        }
        return items.toArray(new Item[0]);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            ClientboundBlockEntityDataPacket updatePacket = this.getUpdatePacket();
            for (ServerPlayer player : GeneralUtil.tracking((ServerLevel)this.f_58857_, this.m_58899_())) {
                player.f_8906_.m_9829_((Packet)updatePacket);
            }
        }
        super.m_6596_();
    }
}

