/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherGameEvents;
import com.aetherteam.aether.advancement.AetherAdvancementTriggers;
import com.aetherteam.aether.api.AetherAdvancementSoundOverrides;
import com.aetherteam.aether.api.AetherMenus;
import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.AetherCauldronInteractions;
import com.aetherteam.aether.block.dispenser.AetherDispenseBehaviors;
import com.aetherteam.aether.block.dispenser.DispenseDartBehavior;
import com.aetherteam.aether.block.dispenser.DispenseSkyrootBoatBehavior;
import com.aetherteam.aether.block.dispenser.DispenseUsableItemBehavior;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.CombinedPackResources;
import com.aetherteam.aether.client.TriviaGenerator;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.command.SunAltarWhitelist;
import com.aetherteam.aether.data.AetherData;
import com.aetherteam.aether.data.resources.AetherMobCategory;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.ai.AetherBlockPathTypes;
import com.aetherteam.aether.inventory.AetherRecipeBookTypes;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.item.AetherCreativeTabs;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.loot.conditions.AetherLootConditions;
import com.aetherteam.aether.loot.functions.AetherLootFunctions;
import com.aetherteam.aether.loot.modifiers.AetherLootModifiers;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.perk.types.MoaSkins;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.world.AetherPoi;
import com.aetherteam.aether.world.feature.AetherFeatures;
import com.aetherteam.aether.world.foliageplacer.AetherFoliagePlacerTypes;
import com.aetherteam.aether.world.placementmodifier.AetherPlacementModifiers;
import com.aetherteam.aether.world.processor.AetherStructureProcessors;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import com.aetherteam.aether.world.treedecorator.AetherTreeDecoratorTypes;
import com.aetherteam.aether.world.trunkplacer.AetherTrunkPlacerTypes;
import com.google.common.reflect.Reflection;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;

@Mod(value="aether")
public class Aether {
    public static final String MODID = "aether";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Path DIRECTORY = FMLPaths.CONFIGDIR.get().resolve("aether");
    public static final TriviaGenerator TRIVIA_READER = new TriviaGenerator();

    public Aether() {
        DeferredRegister[] registers;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(AetherData::dataSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::packSetup);
        for (DeferredRegister register : registers = new DeferredRegister[]{AetherBlocks.BLOCKS, AetherItems.ITEMS, AetherEntityTypes.ENTITY_TYPES, AetherBlockEntityTypes.BLOCK_ENTITY_TYPES, AetherMenuTypes.MENU_TYPES, AetherEffects.EFFECTS, AetherParticleTypes.PARTICLES, AetherFeatures.FEATURES, AetherFoliagePlacerTypes.FOLIAGE_PLACERS, AetherTrunkPlacerTypes.TRUNK_PLACERS, AetherTreeDecoratorTypes.TREE_DECORATORS, AetherPoi.POI, AetherStructureTypes.STRUCTURE_TYPES, AetherStructurePieceTypes.STRUCTURE_PIECE_TYPES, AetherStructureProcessors.STRUCTURE_PROCESSOR_TYPES, AetherRecipeTypes.RECIPE_TYPES, AetherRecipeSerializers.RECIPE_SERIALIZERS, AetherLootFunctions.LOOT_FUNCTION_TYPES, AetherLootConditions.LOOT_CONDITION_TYPES, AetherLootModifiers.GLOBAL_LOOT_MODIFIERS, AetherSoundEvents.SOUNDS, AetherGameEvents.GAME_EVENTS, AetherAdvancementSoundOverrides.ADVANCEMENT_SOUND_OVERRIDES, AetherMoaTypes.MOA_TYPES, AetherCreativeTabs.CREATIVE_MODE_TABS}) {
            register.register(modEventBus);
        }
        DistExecutor.unsafeRunForDist(() -> () -> {
            AetherMenus.MENUS.register(modEventBus);
            return true;
        }, () -> () -> false);
        AetherBlocks.registerWoodTypes();
        DIRECTORY.toFile().mkdirs();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)AetherConfig.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AetherConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)AetherConfig.CLIENT_SPEC);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        AetherPacketHandler.register();
        Reflection.initialize((Class[])new Class[]{SunAltarWhitelist.class});
        Reflection.initialize((Class[])new Class[]{AetherPlacementModifiers.class});
        Reflection.initialize((Class[])new Class[]{AetherRecipeBookTypes.class});
        Reflection.initialize((Class[])new Class[]{AetherBlockPathTypes.class});
        Reflection.initialize((Class[])new Class[]{AetherMobCategory.class});
        AetherAdvancementTriggers.init();
        MoaSkins.registerMoaSkins();
        event.enqueueWork(() -> {
            AetherBlocks.registerFuels();
            AetherBlocks.registerPots();
            AetherBlocks.registerFlammability();
            AetherBlocks.registerFluidInteractions();
            AetherItems.setupBucketReplacements();
            this.registerDispenserBehaviors();
            this.registerCauldronInteractions();
            this.registerComposting();
        });
    }

    public void packSetup(AddPackFindersEvent event) {
        this.setupReleasePack(event);
        this.setupBetaPack(event);
        this.setupCTMFixPack(event);
        this.setupTipsPack(event);
        this.setupColorblindPack(event);
        this.setupAccessoriesPack(event);
        this.setupCuriosOverridePack(event);
        this.setupTemporaryFreezingPack(event);
        this.setupRuinedPortalPack(event);
    }

    private void setupReleasePack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/classic_125"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, false, resourcePath);
            this.createCombinedPack(event, resourcePath, pack, "builtin/aether_125_art", "pack.aether.125.title", "pack.aether.125.description");
        }
    }

    private void setupBetaPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/classic_b173"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, false, resourcePath);
            this.createCombinedPack(event, resourcePath, pack, "builtin/aether_b173_art", "pack.aether.b173.title", "pack.aether.b173.description");
        }
    }

    private void createCombinedPack(AddPackFindersEvent event, Path sourcePath, PathPackResources pack, String name, String title, String description) {
        Path baseResourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/classic_base"});
        PathPackResources basePack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + baseResourcePath, false, baseResourcePath);
        List<PathPackResources> mergedPacks = List.of(pack, basePack);
        Pack.ResourcesSupplier resourcesSupplier = string -> new CombinedPackResources(name, new PackMetadataSection((Component)Component.m_237115_((String)description), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES)), mergedPacks, sourcePath);
        Pack.Info info = Pack.m_246334_((String)name, (Pack.ResourcesSupplier)resourcesSupplier);
        if (info != null) {
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)name, (Component)Component.m_237115_((String)title), (boolean)false, (Pack.ResourcesSupplier)resourcesSupplier, (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }

    private void setupCTMFixPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES && ModList.get().isLoaded("ctm")) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/ctm_fix"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)"pack.aether.ctm.description"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/aether_ctm_fix", (Component)Component.m_237115_((String)"pack.aether.ctm.title"), (boolean)true, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }

    private void setupTipsPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES && ModList.get().isLoaded("tipsmod")) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/tips"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)"pack.aether.tips.description"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/aether_tips", (Component)Component.m_237115_((String)"pack.aether.tips.title"), (boolean)false, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }

    private void setupColorblindPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/colorblind"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)"pack.aether.colorblind.description"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/aether_colorblind", (Component)Component.m_237115_((String)"pack.aether.colorblind.title"), (boolean)false, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }

    private void setupAccessoriesPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA && !((Boolean)AetherConfig.COMMON.use_curios_menu.get()).booleanValue()) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/accessories"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)"pack.aether.accessories.description"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/aether_accessories", (Component)Component.m_237115_((String)"pack.aether.accessories.title"), (boolean)true, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }

    private void setupCuriosOverridePack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA && ((Boolean)AetherConfig.COMMON.use_curios_menu.get()).booleanValue()) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/curios_override"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)"pack.aether.curios.description"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/aether_curios_override", (Component)Component.m_237115_((String)"pack.aether.curios.title"), (boolean)true, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }

    private void setupTemporaryFreezingPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/temporary_freezing"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)"pack.aether.freezing.description"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/aether_temporary_freezing", (Component)Component.m_237115_((String)"pack.aether.freezing.title"), (boolean)false, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)Aether.create(Aether.decorateWithSource("pack.source.builtin"), (Boolean)AetherConfig.COMMON.add_temporary_freezing_automatically.get()))));
        }
    }

    private void setupRuinedPortalPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/ruined_portal"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)"pack.aether.ruined_portal.description"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/aether_ruined_portal", (Component)Component.m_237115_((String)"pack.aether.ruined_portal.title"), (boolean)false, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)Aether.create(Aether.decorateWithSource("pack.source.builtin"), (Boolean)AetherConfig.COMMON.add_ruined_portal_automatically.get()))));
        }
    }

    static PackSource create(final UnaryOperator<Component> decorator, final boolean shouldAddAutomatically) {
        return new PackSource(){

            public Component m_10540_(Component component) {
                return (Component)decorator.apply(component);
            }

            public boolean m_245251_() {
                return shouldAddAutomatically;
            }
        };
    }

    private static UnaryOperator<Component> decorateWithSource(String translationKey) {
        MutableComponent component = Component.m_237115_((String)translationKey);
        return arg_0 -> Aether.lambda$decorateWithSource$21((Component)component, arg_0);
    }

    private void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.GOLDEN_DART.get()), (DispenseItemBehavior)new DispenseDartBehavior((Supplier<? extends Item>)AetherItems.GOLDEN_DART));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.POISON_DART.get()), (DispenseItemBehavior)new DispenseDartBehavior((Supplier<? extends Item>)AetherItems.POISON_DART));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.ENCHANTED_DART.get()), (DispenseItemBehavior)new DispenseDartBehavior((Supplier<? extends Item>)AetherItems.ENCHANTED_DART));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.LIGHTNING_KNIFE.get()), (DispenseItemBehavior)AetherDispenseBehaviors.DISPENSE_LIGHTNING_KNIFE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.HAMMER_OF_KINGBDOGZ.get()), (DispenseItemBehavior)AetherDispenseBehaviors.DISPENSE_KINGBDOGZ_HAMMER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.SKYROOT_WATER_BUCKET.get()), (DispenseItemBehavior)AetherDispenseBehaviors.SKYROOT_BUCKET_DISPENSE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.SKYROOT_BUCKET.get()), (DispenseItemBehavior)AetherDispenseBehaviors.SKYROOT_BUCKET_PICKUP_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.AMBROSIUM_SHARD.get()), new DispenseUsableItemBehavior((RecipeType)AetherRecipeTypes.AMBROSIUM_ENCHANTING.get()));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.SWET_BALL.get()), new DispenseUsableItemBehavior((RecipeType)AetherRecipeTypes.SWET_BALL_CONVERSION.get()));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.SKYROOT_BOAT.get()), (DispenseItemBehavior)new DispenseSkyrootBoatBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AetherItems.SKYROOT_CHEST_BOAT.get()), (DispenseItemBehavior)new DispenseSkyrootBoatBehavior(true));
    }

    private void registerCauldronInteractions() {
        CauldronInteraction.f_175606_.put((Item)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        CauldronInteraction.f_175607_.put((Item)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        CauldronInteraction.f_175608_.put((Item)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        CauldronInteraction.f_175609_.put((Item)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        CauldronInteraction.f_175606_.put((Item)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        CauldronInteraction.f_175607_.put((Item)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        CauldronInteraction.f_175608_.put((Item)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        CauldronInteraction.f_175609_.put((Item)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        CauldronInteraction.f_175607_.put((Item)AetherItems.SKYROOT_BUCKET.get(), AetherCauldronInteractions.EMPTY_WATER);
        CauldronInteraction.f_175609_.put((Item)AetherItems.SKYROOT_BUCKET.get(), AetherCauldronInteractions.EMPTY_POWDER_SNOW);
        CauldronInteraction.f_175607_.put((Item)AetherItems.LEATHER_GLOVES.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)AetherItems.RED_CAPE.get(), AetherCauldronInteractions.CAPE);
        CauldronInteraction.f_175607_.put((Item)AetherItems.BLUE_CAPE.get(), AetherCauldronInteractions.CAPE);
        CauldronInteraction.f_175607_.put((Item)AetherItems.YELLOW_CAPE.get(), AetherCauldronInteractions.CAPE);
    }

    private void registerComposting() {
        this.addCompost(0.3f, (ItemLike)((Block)AetherBlocks.SKYROOT_LEAVES.get()).m_5456_());
        this.addCompost(0.3f, (ItemLike)AetherBlocks.SKYROOT_SAPLING.get());
        this.addCompost(0.3f, (ItemLike)AetherBlocks.GOLDEN_OAK_LEAVES.get());
        this.addCompost(0.3f, (ItemLike)AetherBlocks.GOLDEN_OAK_SAPLING.get());
        this.addCompost(0.3f, (ItemLike)AetherBlocks.CRYSTAL_LEAVES.get());
        this.addCompost(0.3f, (ItemLike)AetherBlocks.CRYSTAL_FRUIT_LEAVES.get());
        this.addCompost(0.3f, (ItemLike)AetherBlocks.HOLIDAY_LEAVES.get());
        this.addCompost(0.3f, (ItemLike)AetherBlocks.DECORATED_HOLIDAY_LEAVES.get());
        this.addCompost(0.3f, (ItemLike)AetherItems.BLUE_BERRY.get());
        this.addCompost(0.5f, (ItemLike)AetherItems.ENCHANTED_BERRY.get());
        this.addCompost(0.5f, (ItemLike)AetherBlocks.BERRY_BUSH.get());
        this.addCompost(0.5f, (ItemLike)AetherBlocks.BERRY_BUSH_STEM.get());
        this.addCompost(0.65f, (ItemLike)AetherBlocks.WHITE_FLOWER.get());
        this.addCompost(0.65f, (ItemLike)AetherBlocks.PURPLE_FLOWER.get());
        this.addCompost(0.65f, (ItemLike)AetherItems.WHITE_APPLE.get());
    }

    private void addCompost(float chance, ItemLike item) {
        ComposterBlock.f_51914_.put((Object)item.m_5456_(), chance);
    }

    private static /* synthetic */ Component lambda$decorateWithSource$21(Component component, Component name) {
        return Component.m_237110_((String)"pack.nameAndSource", (Object[])new Object[]{name, component}).m_130940_(ChatFormatting.GRAY);
    }
}

