/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.block;

import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.block.entity.ApplePressBlockEntity;
import net.satisfy.vinery.registry.BlockEntityTypeRegistry;
import net.satisfy.vinery.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplePressBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.m_61587_((String)"half", DoubleBlockHalf.class);
    public static final Map<Direction, VoxelShape> TOP_SHAPES = new HashMap<Direction, VoxelShape>();
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPES = new HashMap<Direction, VoxelShape>();

    public ApplePressBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.f_46443_) {
            boolean isCompleteRemoval;
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
            BlockPos otherPartPos = half == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
            BlockState otherPartState = world.m_8055_(otherPartPos);
            boolean otherPartRemoved = otherPartState.m_60734_() != this || otherPartState.m_61143_(HALF) == half;
            boolean bl = isCompleteRemoval = state.m_60734_() != newState.m_60734_() && newState.m_60795_();
            if (otherPartState.m_60734_() == this && otherPartState.m_61143_(HALF) != half) {
                world.m_7731_(otherPartPos, Blocks.f_50016_.m_49966_(), 35);
                world.m_46796_(2001, otherPartPos, Block.m_49956_((BlockState)otherPartState));
            }
            if (isCompleteRemoval && (half == DoubleBlockHalf.UPPER || half == DoubleBlockHalf.LOWER && otherPartRemoved)) {
                ApplePressBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos upperPos;
        BlockState upperState;
        if (!player.m_7500_() && state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            ItemStack itemStack = new ItemStack((ItemLike)ObjectRegistry.APPLE_PRESS.get());
            ApplePressBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)itemStack);
        } else if (!player.m_7500_() && state.m_61143_(HALF) == DoubleBlockHalf.LOWER && (upperState = world.m_8055_(upperPos = pos.m_7494_())).m_60734_() == this && upperState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            ItemStack itemStack = new ItemStack((ItemLike)ObjectRegistry.APPLE_PRESS.get());
            ApplePressBlock.m_49840_((Level)world, (BlockPos)upperPos, (ItemStack)itemStack);
        }
        super.m_5707_(world, pos, state, player);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        MenuProvider screenHandlerFactory;
        if (!world.f_46443_ && (screenHandlerFactory = state.m_60750_(world, pos)) != null) {
            player.m_5893_(screenHandlerFactory);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ApplePressBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return ApplePressBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockEntityTypeRegistry.APPLE_PRESS_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1, (ApplePressBlockEntity)be));
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (pos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(pos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockPos upperPos = pos.m_7494_();
            BlockState upperState = (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER);
            world.m_7731_(upperPos, upperState, 3);
        }
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return TOP_SHAPES.get(facing);
        }
        return BOTTOM_SHAPES.get(facing);
    }

    private static VoxelShape makeTopShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.46875, (double)0.3125, (double)0.46875, (double)0.53125, (double)0.8125, (double)0.53125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.8125, (double)0.375, (double)0.625, (double)0.875, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.40625, (double)0.125, (double)0.625, (double)0.59375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)0.40625, (double)1.0, (double)0.625, (double)0.59375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.40625, (double)0.875, (double)0.625, (double)0.59375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.3125, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.3125, (double)0.46875, (double)0.875, (double)0.4375, (double)0.53125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0625, (double)0.125, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)0.0625, (double)1.0, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.40625, (double)0.125, (double)1.0, (double)0.59375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.125, (double)0.40625, (double)1.0, (double)1.0, (double)0.59375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.5625, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)0.5625, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    static {
        Supplier<VoxelShape> topShapeSupplier = ApplePressBlock::makeTopShape;
        Supplier<VoxelShape> bottomShapeSupplier = ApplePressBlock::makeBottomShape;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            TOP_SHAPES.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)topShapeSupplier.get()));
            BOTTOM_SHAPES.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)bottomShapeSupplier.get()));
        }
    }
}

