/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class IngredientUtil {
    public static Ingredient getTagedIngredientOrEmpty(String modid, String tagName) {
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        assert (tagManager != null);
        return Ingredient.m_204132_((TagKey)tagManager.createTagKey(new ResourceLocation(modid, tagName)));
    }

    public static Ingredient getItemOrEmpty(String modid, String itemName) {
        ResourceLocation itemLoctaion = new ResourceLocation(modid + ":" + itemName);
        if (ForgeRegistries.ITEMS.containsKey(itemLoctaion)) {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(itemLoctaion)});
        }
        return Ingredient.f_43901_;
    }

    public static ItemLike[] toItemLikeArray(Ingredient ingredient) {
        ItemLike[] list = new ItemLike[ingredient.m_43908_().length];
        for (int i = 0; i < ingredient.m_43908_().length; ++i) {
            list[i] = ingredient.m_43908_()[i].m_41720_();
        }
        return list;
    }

    public static ItemLike[] toItemLikeArray(ResourceLocation ... locations) {
        ItemLike[] list = new ItemLike[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            list[i] = (ItemLike)ForgeRegistries.ITEMS.getValue(locations[i]);
        }
        return list;
    }

    public static ItemLike[] toItemLikeArray(List<String> locations) {
        ItemLike[] list = new ItemLike[locations.size()];
        for (int i = 0; i < locations.size(); ++i) {
            list[i] = (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(locations.get(i)));
        }
        return list;
    }

    public static List<String> getItemStringFromIngrediant(Ingredient ingredient) {
        ItemStack[] items = ingredient.m_43908_();
        ArrayList<String> itemStrings = new ArrayList<String>();
        for (ItemStack item : items) {
            itemStrings.add(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()), "ItemStack has no item in Ingredient").toString());
        }
        return itemStrings;
    }

    public static Ingredient getIngrediantFromItemString(List<String> itemList) {
        if (itemList == null) {
            return Ingredient.f_43901_;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (String itemString : itemList) {
            if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemString))) continue;
            items.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString)));
        }
        return Ingredient.m_43921_(items.stream().map(ItemStack::new));
    }
}

