/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.util;

import com.userofbricks.expanded_combat.api.registry.ECPlugin;
import com.userofbricks.expanded_combat.api.registry.IExpandedCombatPlugin;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public class ECPluginFinder {
    private static final Logger LOGGER = LogManager.getLogger();

    private ECPluginFinder() {
    }

    public static List<IExpandedCombatPlugin> getECPlugins() {
        List<IExpandedCombatPlugin> pluginList = ECPluginFinder.getInstances(ECPlugin.class, IExpandedCombatPlugin.class);
        pluginList.sort(Comparator.comparingInt(IExpandedCombatPlugin::loadOrder));
        return pluginList;
    }

    private static <T> List<T> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType(annotationClass);
        Set<String> pluginClassNames = ECPluginFinder.getPluginClassNames(annotationType);
        ArrayList<T> instances = new ArrayList<T>();
        for (String className : pluginClassNames) {
            try {
                Class<?> asmClass = Class.forName(className);
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                Constructor<T> constructor = asmInstanceClass.getDeclaredConstructor(new Class[0]);
                T instance = constructor.newInstance(new Object[0]);
                instances.add(instance);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                LOGGER.error("Failed to load: {}", (Object)className, (Object)e);
            }
        }
        return instances;
    }

    @NotNull
    private static Set<String> getPluginClassNames(Type annotationType) {
        List allScanData = ModList.get().getAllScanData();
        LinkedHashSet<String> pluginClassNames = new LinkedHashSet<String>();
        for (ModFileScanData scanData : allScanData) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                if (!Objects.equals(a.annotationType(), annotationType)) continue;
                boolean readyToLoad = true;
                if (a.annotationData().get("required") != null) {
                    for (String modId : (ArrayList)a.annotationData().get("required")) {
                        if (ModList.get().isLoaded(modId)) continue;
                        readyToLoad = false;
                        LOGGER.debug("Mod " + modId + " is not loaded for EC Plugin Class " + a.memberName() + " so it was not loaded");
                        break;
                    }
                }
                if (!readyToLoad) continue;
                String memberName = a.memberName();
                pluginClassNames.add(memberName);
            }
        }
        return pluginClassNames;
    }
}

