/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public class AddItemFromGauntletModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemFromGauntletModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemFromGauntletModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("loot_item").forGetter(m -> m.lootItem)).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("gauntlet").forGetter(m -> m.gauntlet)).apply((Applicative)inst, AddItemFromGauntletModifier::new)));
    protected final Item lootItem;
    protected final Item gauntlet;

    public AddItemFromGauntletModifier(LootItemCondition[] conditionsIn, Item lootItem, Item gauntlet) {
        super(conditionsIn);
        this.lootItem = lootItem;
        this.gauntlet = gauntlet;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        Object object = context.m_78953_(LootContextParams.f_81458_);
        if (object instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)object;
            Optional optionalSlotResult = CuriosApi.getCuriosHelper().findFirstCurio(killer, this.gauntlet);
            if (optionalSlotResult.isPresent()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.lootItem));
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

