/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item.recipes.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.config.MaterialConfig;
import com.userofbricks.expanded_combat.init.MaterialInit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ECMaterialBooleanCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("expanded_combat", "config_material_boolean");
    private final String materialName;
    private final String[] locationPath;

    public ECMaterialBooleanCondition(String configBooleanName, String ... locationPath) {
        this.materialName = configBooleanName;
        this.locationPath = locationPath;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        boolean result;
        Material material = MaterialInit.valueOf(this.materialName);
        Iterator locationIterator = Arrays.stream(this.locationPath).iterator();
        if (!locationIterator.hasNext()) {
            return false;
        }
        block4 : switch ((String)locationIterator.next()) {
            default: {
                result = false;
                break;
            }
            case "halfbow": {
                result = material.halfbow;
                break;
            }
            case "config": {
                MaterialConfig config = material.getConfig();
                if (!locationIterator.hasNext()) {
                    return false;
                }
                switch ((String)locationIterator.next()) {
                    default: {
                        result = false;
                        break block4;
                    }
                    case "fire_resistant": {
                        result = config.fireResistant;
                        break block4;
                    }
                    case "offense": {
                        MaterialConfig.Offense offense = config.offense;
                        if (!locationIterator.hasNext()) {
                            return false;
                        }
                        switch ((String)locationIterator.next()) {
                            default: {
                                result = false;
                                break block4;
                            }
                            case "flaming": {
                                result = offense.flaming;
                                break block4;
                            }
                            case "can_be_tipped": 
                        }
                        result = offense.canBeTipped;
                        break block4;
                    }
                    case "crafting": 
                }
                MaterialConfig.Crafting crafting = config.crafting;
                if (!locationIterator.hasNext()) {
                    return false;
                }
                result = "is_single_addition".equals(locationIterator.next()) ? crafting.isSingleAddition : false;
            }
        }
        return result;
    }

    public String toString() {
        return "config_boolean(\"" + this.materialName + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<ECMaterialBooleanCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ECMaterialBooleanCondition value) {
            json.addProperty("material", value.materialName);
            JsonArray locationPath = new JsonArray();
            for (String location : value.locationPath) {
                locationPath.add(location);
            }
            json.add("location_path", (JsonElement)locationPath);
        }

        public ECMaterialBooleanCondition read(JsonObject json) {
            ArrayList<String> locationList = new ArrayList<String>();
            List locations = json.getAsJsonArray("location_path").asList();
            for (JsonElement location : locations) {
                locationList.add(location.getAsString());
            }
            return new ECMaterialBooleanCondition(GsonHelper.m_13906_((JsonObject)json, (String)"material"), locationList.toArray(new String[0]));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

