/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item.recipes.conditions;

import com.google.gson.JsonObject;
import com.userofbricks.expanded_combat.ExpandedCombat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ECConfigBooleanCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("expanded_combat", "config_boolean");
    private final String configBooleanName;

    public ECConfigBooleanCondition(String configBooleanName) {
        this.configBooleanName = configBooleanName;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return switch (this.configBooleanName) {
            default -> false;
            case "gauntlet" -> ExpandedCombat.CONFIG.enableGauntlets;
            case "shield" -> ExpandedCombat.CONFIG.enableShields;
            case "bow" -> ExpandedCombat.CONFIG.enableBows;
            case "half_bow" -> ExpandedCombat.CONFIG.enableHalfBows;
            case "crossbow" -> ExpandedCombat.CONFIG.enableCrossbows;
            case "arrow" -> ExpandedCombat.CONFIG.enableArrows;
            case "weapon" -> ExpandedCombat.CONFIG.enableWeapons;
        };
    }

    public String toString() {
        return "config_boolean(\"" + this.configBooleanName + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<ECConfigBooleanCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ECConfigBooleanCondition value) {
            json.addProperty("config_entry", value.configBooleanName);
        }

        public ECConfigBooleanCondition read(JsonObject json) {
            return new ECConfigBooleanCondition(GsonHelper.m_13906_((JsonObject)json, (String)"config_entry"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

