/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item.recipes.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.userofbricks.expanded_combat.init.ECRecipeSerializerInit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SmithingTransformWithoutTemplateRecipeBuilder {
    private final Ingredient base;
    private final Ingredient addition;
    private final RecipeCategory category;
    private final Item result;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private final RecipeSerializer<?> type;

    public SmithingTransformWithoutTemplateRecipeBuilder(RecipeSerializer<?> type, Ingredient base, Ingredient addition, RecipeCategory recipeCategory, Item result) {
        this.category = recipeCategory;
        this.type = type;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public static SmithingTransformWithoutTemplateRecipeBuilder smithing(Ingredient base, Ingredient addition, RecipeCategory recipeCategory, Item result) {
        return new SmithingTransformWithoutTemplateRecipeBuilder((RecipeSerializer)ECRecipeSerializerInit.SMITHING_TRANSFORM_WITHOUT_TEMPLATE.get(), base, addition, recipeCategory, result);
    }

    public SmithingTransformWithoutTemplateRecipeBuilder unlocks(String p_266919_, CriterionTriggerInstance p_267277_) {
        this.advancement.m_138386_(p_266919_, p_267277_);
        return this;
    }

    public void save(Consumer<FinishedRecipe> p_267068_, String p_267035_) {
        this.save(p_267068_, new ResourceLocation(p_267035_));
    }

    public void save(Consumer<FinishedRecipe> p_267089_, ResourceLocation p_267287_) {
        this.ensureValid(p_267287_);
        this.advancement.m_138396_(RecipeBuilder.f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_267287_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_267287_)).m_138360_(RequirementsStrategy.f_15979_);
        p_267089_.accept(new Result(p_267287_, this.type, this.base, this.addition, this.result, this.advancement, p_267287_.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation p_267259_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_267259_);
        }
    }

    public record Result(ResourceLocation id, RecipeSerializer<?> type, Ingredient base, Ingredient addition, Item result, Advancement.Builder advancement, ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(JsonObject p_266713_) {
            p_266713_.add("base", this.base.m_43942_());
            p_266713_.add("addition", this.addition.m_43942_());
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            p_266713_.add("result", (JsonElement)jsonobject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

