/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item.recipes.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.userofbricks.expanded_combat.init.ECRecipeSerializerInit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class FletchingRecipeBuilder {
    private final Ingredient base;
    private final Ingredient addition;
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final int maxResultingCount;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public FletchingRecipeBuilder(Ingredient base, Ingredient addition, RecipeCategory category, Item result, int count, int maxResultingCount) {
        this.base = base;
        this.addition = addition;
        this.category = category;
        this.result = result;
        this.count = count;
        this.maxResultingCount = maxResultingCount;
    }

    public static FletchingRecipeBuilder fletching(Ingredient base, Ingredient addition, RecipeCategory category, Item result, int count) {
        return new FletchingRecipeBuilder(base, addition, category, result, count, 1);
    }

    public static FletchingRecipeBuilder fletchingVarableResult(Ingredient base, Ingredient addition, RecipeCategory category, Item result, int maxResultingCount) {
        return new FletchingRecipeBuilder(base, addition, category, result, 1, maxResultingCount);
    }

    public FletchingRecipeBuilder unlocks(String unlockName, CriterionTriggerInstance triggerInstance) {
        this.advancement.m_138386_(unlockName, triggerInstance);
        return this;
    }

    public void save(Consumer<FinishedRecipe> p_266900_, String p_266899_) {
        this.save(p_266900_, new ResourceLocation(p_266899_));
    }

    public void save(Consumer<FinishedRecipe> p_266852_, ResourceLocation p_267253_) {
        this.ensureValid(p_267253_);
        this.advancement.m_138396_(RecipeBuilder.f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_267253_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_267253_)).m_138360_(RequirementsStrategy.f_15979_);
        p_266852_.accept(new Result(p_267253_, this.base, this.addition, this.result, this.count, this.maxResultingCount, this.advancement, p_267253_.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation p_266958_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_266958_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient base;
        private final Ingredient addition;
        private final Item result;
        private final int count;
        private final int maxResultingCount;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation location, Ingredient base, Ingredient addition, Item result, int count, int maxResultingCount, Advancement.Builder advancementBuilder, ResourceLocation advancementLocation) {
            this.id = location;
            this.base = base;
            this.addition = addition;
            this.result = result;
            this.advancement = advancementBuilder;
            this.advancementId = advancementLocation;
            this.count = count;
            this.maxResultingCount = maxResultingCount;
        }

        public void m_7917_(JsonObject recipeJsonObject) {
            recipeJsonObject.add("base", this.base.m_43942_());
            recipeJsonObject.add("addition", this.addition.m_43942_());
            JsonObject itemJsonObject = new JsonObject();
            itemJsonObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                itemJsonObject.addProperty("count", (Number)this.count);
            }
            recipeJsonObject.add("result", (JsonElement)itemJsonObject);
            if (this.maxResultingCount > 1) {
                recipeJsonObject.addProperty("max_output_repeat", (Number)this.maxResultingCount);
            }
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ECRecipeSerializerInit.EC_FLETCHING_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

