/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item.recipes;

import com.google.gson.JsonObject;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.init.ECItems;
import com.userofbricks.expanded_combat.init.ECRecipeSerializerInit;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.item.ECShieldItem;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ShieldSmithingUpgradeRecipe
extends SmithingTransformRecipe {
    public ShieldSmithingUpgradeRecipe(ResourceLocation id) {
        super(id, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, new ItemStack((ItemLike)ECItems.SHIELD_TIER_1.get()));
    }

    public boolean m_5818_(Container inventory, @Nonnull Level world) {
        Material existing_dl_material;
        ItemStack base = inventory.m_8020_(1);
        if (!(base.m_41720_() instanceof ECShieldItem)) {
            return false;
        }
        if (inventory.m_8020_(2).m_41619_()) {
            return false;
        }
        Material existing_ur_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("ur", ECShieldItem.getUpperRightMaterial(base)) : MaterialInit.getMaterialForShieldPart("ur", (ItemLike)base.m_41720_());
        Material existing_ul_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("ul", ECShieldItem.getUpperLeftMaterial(base)) : MaterialInit.getMaterialForShieldPart("ul", (ItemLike)base.m_41720_());
        Material addition_m_material = MaterialInit.valueOfShield(inventory.m_8020_(2));
        Material existing_m_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("m", ECShieldItem.getMiddleMaterial(base)) : MaterialInit.getMaterialForShieldPart("m", (ItemLike)base.m_41720_());
        Material existing_dr_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("dr", ECShieldItem.getDownRightMaterial(base)) : MaterialInit.getMaterialForShieldPart("dr", (ItemLike)base.m_41720_());
        Material material = existing_dl_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("dl", ECShieldItem.getDownLeftMaterial(base)) : MaterialInit.getMaterialForShieldPart("dl", (ItemLike)base.m_41720_());
        if (!addition_m_material.getConfig().crafting.isSingleAddition) {
            return false;
        }
        if (inventory.m_8020_(0).m_41720_() != ForgeRegistries.ITEMS.getValue(new ResourceLocation(addition_m_material.getConfig().crafting.smithingTemplate))) {
            return false;
        }
        return addition_m_material.satifiesOnlyReplaceRequirement(existing_ur_material.getName()) || addition_m_material.satifiesOnlyReplaceRequirement(existing_ul_material.getName()) || addition_m_material.satifiesOnlyReplaceRequirement(existing_m_material.getName()) || addition_m_material.satifiesOnlyReplaceRequirement(existing_dr_material.getName()) || addition_m_material.satifiesOnlyReplaceRequirement(existing_dl_material.getName());
    }

    @NotNull
    public ItemStack m_5874_(Container inventory, @NotNull RegistryAccess p_267165_) {
        ItemStack base = inventory.m_8020_(1);
        Material ul_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("ul", ECShieldItem.getUpperLeftMaterial(base)) : MaterialInit.getMaterialForShieldPart("ul", (ItemLike)base.m_41720_());
        Material ur_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("ur", ECShieldItem.getUpperRightMaterial(base)) : MaterialInit.getMaterialForShieldPart("ur", (ItemLike)base.m_41720_());
        Material dl_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("dl", ECShieldItem.getDownLeftMaterial(base)) : MaterialInit.getMaterialForShieldPart("dl", (ItemLike)base.m_41720_());
        Material dr_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("dr", ECShieldItem.getDownRightMaterial(base)) : MaterialInit.getMaterialForShieldPart("dr", (ItemLike)base.m_41720_());
        Material m_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("m", ECShieldItem.getMiddleMaterial(base)) : MaterialInit.getMaterialForShieldPart("m", (ItemLike)base.m_41720_());
        Material addition_material = MaterialInit.valueOfShield(inventory.m_8020_(2));
        Material result_ul_material = addition_material.satifiesOnlyReplaceRequirement(ul_material.getName()) ? addition_material : ul_material;
        Material result_ur_material = addition_material.satifiesOnlyReplaceRequirement(ur_material.getName()) ? addition_material : ur_material;
        Material result_dl_material = addition_material.satifiesOnlyReplaceRequirement(dl_material.getName()) ? addition_material : dl_material;
        Material result_dr_material = addition_material.satifiesOnlyReplaceRequirement(dr_material.getName()) ? addition_material : dr_material;
        Material result_m_material = addition_material.satifiesOnlyReplaceRequirement(m_material.getName()) ? addition_material : m_material;
        ItemStack result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_1.get());
        if (result_ul_material.getConfig().fireResistant || result_ur_material.getConfig().fireResistant || result_m_material.getConfig().fireResistant || result_dl_material.getConfig().fireResistant || result_dr_material.getConfig().fireResistant) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_3.get());
        }
        result.m_41784_().m_128359_("UL_Material", result_ul_material.getName());
        result.m_41784_().m_128359_("UR_Material", result_ur_material.getName());
        result.m_41784_().m_128359_("DL_Material", result_dl_material.getName());
        result.m_41784_().m_128359_("DR_Material", result_dr_material.getName());
        result.m_41784_().m_128359_("M_Material", result_m_material.getName());
        return result;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)ECItems.SHIELD_TIER_1.get());
    }

    public boolean m_266166_(@NotNull ItemStack stack) {
        return stack.m_41619_() || stack.m_41720_() == Items.f_265918_;
    }

    public boolean m_266343_(@NotNull ItemStack stack) {
        return stack.m_41720_() instanceof ECShieldItem;
    }

    public boolean m_266253_(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializerInit.EC_SMITHING_UPGRADING_SHIELD_SERIALIZER.get();
    }

    @ParametersAreNonnullByDefault
    public static class Serializer
    implements RecipeSerializer<ShieldSmithingUpgradeRecipe> {
        @NotNull
        public ShieldSmithingUpgradeRecipe fromJson(ResourceLocation location, JsonObject jsonObject) {
            return new ShieldSmithingUpgradeRecipe(location);
        }

        public ShieldSmithingUpgradeRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf packetBuffer) {
            return new ShieldSmithingUpgradeRecipe(location);
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, ShieldSmithingUpgradeRecipe shieldSmithingRecipie) {
        }
    }
}

