/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item.recipes;

import com.google.gson.JsonObject;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.init.ECItems;
import com.userofbricks.expanded_combat.init.ECRecipeSerializerInit;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.item.ECItemTags;
import com.userofbricks.expanded_combat.item.ECShieldItem;
import com.userofbricks.expanded_combat.item.recipes.IShieldSmithingRecipe;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ShieldSmithingRecipie
implements IShieldSmithingRecipe {
    public static final ResourceLocation SHIELD_RECIPE_ID = new ResourceLocation("expanded_combat", "ec_shields");
    private final ResourceLocation id;

    public ShieldSmithingRecipie(ResourceLocation id) {
        this.id = id;
    }

    public boolean m_5818_(Container inventory, @Nonnull Level world) {
        ItemStack base = inventory.m_8020_(0);
        if (!Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(ECItemTags.SHIELDS).contains((Object)base.m_41720_())) {
            return false;
        }
        if (inventory.m_8020_(1).m_41619_() && inventory.m_8020_(2).m_41619_() && inventory.m_8020_(3).m_41619_() && inventory.m_8020_(4).m_41619_() && inventory.m_8020_(5).m_41619_()) {
            return false;
        }
        Material ul_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("ul", ECShieldItem.getUpperLeftMaterial(base)) : MaterialInit.getMaterialForShieldPart("ul", (ItemLike)base.m_41720_());
        Material ur_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("ur", ECShieldItem.getUpperRightMaterial(base)) : MaterialInit.getMaterialForShieldPart("ur", (ItemLike)base.m_41720_());
        Material dl_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("dl", ECShieldItem.getDownLeftMaterial(base)) : MaterialInit.getMaterialForShieldPart("dl", (ItemLike)base.m_41720_());
        Material dr_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("dr", ECShieldItem.getDownRightMaterial(base)) : MaterialInit.getMaterialForShieldPart("dr", (ItemLike)base.m_41720_());
        Material m_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("m", ECShieldItem.getMiddleMaterial(base)) : MaterialInit.getMaterialForShieldPart("m", (ItemLike)base.m_41720_());
        Material addition_ul_material = MaterialInit.valueOfShield(inventory.m_8020_(1));
        Material addition_ur_material = MaterialInit.valueOfShield(inventory.m_8020_(2));
        Material addition_dl_material = MaterialInit.valueOfShield(inventory.m_8020_(4));
        Material addition_dr_material = MaterialInit.valueOfShield(inventory.m_8020_(5));
        Material addition_m_material = MaterialInit.valueOfShield(inventory.m_8020_(3));
        if (addition_ul_material.getConfig().crafting.isSingleAddition || addition_ur_material.getConfig().crafting.isSingleAddition || addition_dl_material.getConfig().crafting.isSingleAddition || addition_dr_material.getConfig().crafting.isSingleAddition || addition_m_material.getConfig().crafting.isSingleAddition) {
            return false;
        }
        if (!addition_ul_material.satifiesOnlyReplaceRequirement(ul_material.getName())) {
            return false;
        }
        if (!addition_ur_material.satifiesOnlyReplaceRequirement(ur_material.getName())) {
            return false;
        }
        if (!addition_dl_material.satifiesOnlyReplaceRequirement(dl_material.getName())) {
            return false;
        }
        if (!addition_dr_material.satifiesOnlyReplaceRequirement(dr_material.getName())) {
            return false;
        }
        if (!addition_m_material.satifiesOnlyReplaceRequirement(m_material.getName())) {
            return false;
        }
        boolean is_ul = ul_material != addition_ul_material || inventory.m_8020_(1).m_41720_() == Items.f_41852_;
        boolean is_ur = ur_material != addition_ur_material || inventory.m_8020_(2).m_41720_() == Items.f_41852_;
        boolean is_dl = dl_material != addition_dl_material || inventory.m_8020_(4).m_41720_() == Items.f_41852_;
        boolean is_dr = dr_material != addition_dr_material || inventory.m_8020_(5).m_41720_() == Items.f_41852_;
        boolean is_m = m_material != addition_m_material || inventory.m_8020_(3).m_41720_() == Items.f_41852_;
        return is_ul && is_ur && is_dl && is_dr && is_m;
    }

    @NotNull
    public ItemStack m_5874_(Container inventory, @NotNull RegistryAccess p_267165_) {
        ItemStack base = inventory.m_8020_(0);
        Material ul_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("ul", ECShieldItem.getUpperLeftMaterial(base)) : MaterialInit.getMaterialForShieldPart("ul", (ItemLike)base.m_41720_());
        Material ur_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("ur", ECShieldItem.getUpperRightMaterial(base)) : MaterialInit.getMaterialForShieldPart("ur", (ItemLike)base.m_41720_());
        Material dl_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("dl", ECShieldItem.getDownLeftMaterial(base)) : MaterialInit.getMaterialForShieldPart("dl", (ItemLike)base.m_41720_());
        Material dr_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("dr", ECShieldItem.getDownRightMaterial(base)) : MaterialInit.getMaterialForShieldPart("dr", (ItemLike)base.m_41720_());
        Material m_material = base.m_41720_() instanceof ECShieldItem ? MaterialInit.valueOfShield("m", ECShieldItem.getMiddleMaterial(base)) : MaterialInit.getMaterialForShieldPart("m", (ItemLike)base.m_41720_());
        Material addition_ul_material = MaterialInit.valueOfShield(inventory.m_8020_(1));
        Material addition_ur_material = MaterialInit.valueOfShield(inventory.m_8020_(2));
        Material addition_dl_material = MaterialInit.valueOfShield(inventory.m_8020_(4));
        Material addition_dr_material = MaterialInit.valueOfShield(inventory.m_8020_(5));
        Material addition_m_material = MaterialInit.valueOfShield(inventory.m_8020_(3));
        Material result_ul_material = inventory.m_8020_(1).m_41619_() ? ul_material : addition_ul_material;
        Material result_ur_material = inventory.m_8020_(2).m_41619_() ? ur_material : addition_ur_material;
        Material result_dl_material = inventory.m_8020_(4).m_41619_() ? dl_material : addition_dl_material;
        Material result_dr_material = inventory.m_8020_(5).m_41619_() ? dr_material : addition_dr_material;
        Material result_m_material = inventory.m_8020_(3).m_41619_() ? m_material : addition_m_material;
        ItemStack result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_1.get());
        if (result_ul_material.getConfig().fireResistant || result_ur_material.getConfig().fireResistant || result_m_material.getConfig().fireResistant || result_dl_material.getConfig().fireResistant || result_dr_material.getConfig().fireResistant) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_3.get());
        }
        result.m_41784_().m_128359_("UL_Material", result_ul_material.getName());
        result.m_41784_().m_128359_("UR_Material", result_ur_material.getName());
        result.m_41784_().m_128359_("DL_Material", result_dl_material.getName());
        result.m_41784_().m_128359_("DR_Material", result_dr_material.getName());
        result.m_41784_().m_128359_("M_Material", result_m_material.getName());
        return result;
    }

    @Override
    public Ingredient getBase() {
        return Ingredient.f_43901_;
    }

    @Override
    public Ingredient getURAddition() {
        return Ingredient.f_43901_;
    }

    @Override
    public Ingredient getULAddition() {
        return Ingredient.f_43901_;
    }

    @Override
    public Ingredient getMAddition() {
        return Ingredient.f_43901_;
    }

    @Override
    public Ingredient getDRAddition() {
        return Ingredient.f_43901_;
    }

    @Override
    public Ingredient getDLAddition() {
        return Ingredient.f_43901_;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializerInit.EC_SHIELD_SERIALIZER.get();
    }

    public boolean m_5598_() {
        return true;
    }

    @Override
    public boolean isAdditionIngredient(ItemStack stack) {
        for (Material material : MaterialInit.shieldMaterials) {
            if (!IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem).test(stack) || material.getConfig().crafting.isSingleAddition) continue;
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public static class Serializer
    implements RecipeSerializer<ShieldSmithingRecipie> {
        @NotNull
        public ShieldSmithingRecipie fromJson(ResourceLocation location, JsonObject jsonObject) {
            return new ShieldSmithingRecipie(location);
        }

        public ShieldSmithingRecipie fromNetwork(ResourceLocation location, FriendlyByteBuf packetBuffer) {
            return new ShieldSmithingRecipie(location);
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, ShieldSmithingRecipie shieldSmithingRecipie) {
        }
    }
}

