/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item.recipes;

import com.userofbricks.expanded_combat.init.ECRecipeSerializerInit;
import com.userofbricks.expanded_combat.item.ECWeaponItem;
import java.util.Collection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class PotionDippedWeaponRecipe
extends CustomRecipe {
    public PotionDippedWeaponRecipe(ResourceLocation id, CraftingBookCategory bookCategory) {
        super(id, bookCategory);
    }

    public boolean matches(CraftingContainer inv, @NotNull Level level) {
        int numPotionWeapons = 0;
        int numPotions = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.m_41720_() instanceof ECWeaponItem.HasPotion) {
                if (numPotionWeapons > 0) {
                    return false;
                }
                ++numPotionWeapons;
                continue;
            }
            if (itemstack.m_150930_(Items.f_42739_)) {
                if (numPotions > 0) {
                    return false;
                }
                ++numPotions;
                continue;
            }
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return numPotions == 1 && numPotionWeapons == 1;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        ItemStack potionItem = ItemStack.f_41583_;
        ItemStack potionWeaponItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (item instanceof ECWeaponItem.HasPotion) {
                if (potionWeaponItem != ItemStack.f_41583_) {
                    return ItemStack.f_41583_;
                }
                potionWeaponItem = stack.m_41777_();
                continue;
            }
            if (!stack.m_150930_(Items.f_42739_)) continue;
            if (potionItem != ItemStack.f_41583_) {
                return ItemStack.f_41583_;
            }
            potionItem = stack.m_41777_();
        }
        if (potionItem == ItemStack.f_41583_ || potionWeaponItem == ItemStack.f_41583_) {
            return ItemStack.f_41583_;
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)potionItem);
        PotionUtils.m_43549_((ItemStack)potionWeaponItem, (Potion)potion);
        PotionUtils.m_43552_((ItemStack)potionWeaponItem, (Collection)PotionUtils.m_43571_((ItemStack)potionItem));
        CompoundTag compoundTag = potionWeaponItem.m_41784_();
        String potionName = ForgeRegistries.POTIONS.getKey((Object)potion).m_135815_();
        int potionUses = potionName.contains("strong_") || potionName.contains("long_") ? 90 : 200;
        compoundTag.m_128405_("PotionUses", potionUses);
        compoundTag.m_128405_("MaxPotionUses", potionUses);
        return potionWeaponItem;
    }

    public boolean m_8004_(int w, int h) {
        return w * h >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializerInit.EC_POTION_WEAPON_SERIALIZER.get();
    }
}

