/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.userofbricks.expanded_combat.init.ECRecipeSerializerInit;
import com.userofbricks.expanded_combat.item.recipes.IFletchingRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class FletchingRecipe
implements IFletchingRecipe {
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;
    private final int maxResultingCount;
    private final ResourceLocation id;

    public FletchingRecipe(ResourceLocation resourceLocation, Ingredient baseIn, Ingredient additionIn, ItemStack resultIn, int maxResultingCount) {
        this.id = resourceLocation;
        this.base = baseIn;
        this.addition = additionIn;
        this.result = resultIn;
        this.maxResultingCount = maxResultingCount;
    }

    public boolean m_5818_(Container iInventory, @NotNull Level world) {
        return this.base.test(iInventory.m_8020_(0)) && this.addition.test(iInventory.m_8020_(1));
    }

    @NotNull
    public ItemStack m_5874_(Container iInventory, @NotNull RegistryAccess registryAccess) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag compoundnbt = iInventory.m_8020_(0).m_41783_();
        if (compoundnbt != null) {
            itemstack.m_41751_(compoundnbt.m_6426_());
        }
        int resultCount = Math.min(iInventory.m_8020_(0).m_41613_(), this.maxResultingCount) * itemstack.m_41613_();
        itemstack.m_41764_(resultCount);
        return itemstack;
    }

    @Override
    public Ingredient getBase() {
        return this.base;
    }

    @Override
    public Ingredient getAddition() {
        return this.addition;
    }

    @Override
    public int getMaxCraftingAmount() {
        return this.maxResultingCount;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        return this.result;
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Blocks.f_50622_);
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializerInit.EC_FLETCHING_SERIALIZER.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.base, this.addition});
    }

    public static class Serializer
    implements RecipeSerializer<FletchingRecipe> {
        @NotNull
        public FletchingRecipe fromJson(@NotNull ResourceLocation location, @NotNull JsonObject jsonObject) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"base"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            int maxResultingCount = jsonObject.has("max_output_repeat") ? GsonHelper.m_13927_((JsonObject)jsonObject, (String)"max_output_repeat") : 1;
            return new FletchingRecipe(location, ingredient, ingredient1, itemstack, Math.max(maxResultingCount, 1));
        }

        public FletchingRecipe fromNetwork(@NotNull ResourceLocation location, @NotNull FriendlyByteBuf packetBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)packetBuffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)packetBuffer);
            ItemStack itemstack = packetBuffer.m_130267_();
            int maxResultingCount = packetBuffer.readInt();
            return new FletchingRecipe(location, ingredient, ingredient1, itemstack, maxResultingCount);
        }

        public void toNetwork(@NotNull FriendlyByteBuf packetBuffer, FletchingRecipe fletchingRecipe) {
            fletchingRecipe.base.m_43923_(packetBuffer);
            fletchingRecipe.addition.m_43923_(packetBuffer);
            packetBuffer.m_130055_(fletchingRecipe.result);
            packetBuffer.writeInt(fletchingRecipe.maxResultingCount);
        }
    }
}

