/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.userofbricks.expanded_combat.ExpandedCombat;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.init.ECAttributes;
import com.userofbricks.expanded_combat.init.ECEnchantments;
import com.userofbricks.expanded_combat.item.ECGauntletItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class UniqueStandardGaunlet
extends ECGauntletItem {
    public UniqueStandardGaunlet(Item.Properties properties, Material material) {
        super(properties, material);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap atts = HashMultimap.create();
        double totalBaseDamage = 12.0;
        float totalExtraDamage = ((UniqueStandardGaunlet)stack.m_41720_()).getMaterial().getAdditionalDamageAfterEnchantments().apply(Float.valueOf((float)totalBaseDamage)).floatValue();
        double totalEnchantedDamage = stack.getEnchantmentLevel(Enchantments.f_44989_) * 2;
        atts.put((Object)((Attribute)ECAttributes.GAUNTLET_DMG_WITHOUT_WEAPON.get()), (Object)new AttributeModifier(ATTACK_UUID, "Attack damage bonus", totalBaseDamage + (double)totalExtraDamage + totalEnchantedDamage, AttributeModifier.Operation.ADDITION));
        atts.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_UUID, "Armor bonus", (double)((UniqueStandardGaunlet)stack.m_41720_()).getArmorAmount(), AttributeModifier.Operation.ADDITION));
        double toughness = ((UniqueStandardGaunlet)stack.m_41720_()).getMaterial().getConfig().defense.armorToughness;
        atts.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_UUID, "Armor Toughness bonus", toughness, AttributeModifier.Operation.ADDITION));
        double knockbackResistance = ((UniqueStandardGaunlet)stack.m_41720_()).getMaterial().getConfig().defense.knockbackResistance;
        atts.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback resistance bonus", knockbackResistance + (double)((float)stack.getEnchantmentLevel((Enchantment)ECEnchantments.KNOCKBACK_RESISTANCE.get()) / 5.0f), AttributeModifier.Operation.ADDITION));
        atts.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(KNOCKBACK_UUID, "Knockback bonus", (double)stack.getEnchantmentLevel(Enchantments.f_44980_), AttributeModifier.Operation.ADDITION));
        if (stack.getEnchantmentLevel((Enchantment)ECEnchantments.AGILITY.get()) > 0) {
            atts.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("33dad864-864b-4dbd-acae-88b72cc358cf"), "Agility Attack Speed", (double)stack.getEnchantmentLevel((Enchantment)ECEnchantments.AGILITY.get()) * 0.02, AttributeModifier.Operation.ADDITION));
        }
        return atts;
    }

    @Override
    public Supplier<ICurioRenderer> getGauntletRenderer() {
        return super.getGauntletRenderer();
    }

    @Override
    public ResourceLocation getGauntletTexture(ItemStack stack) {
        return ExpandedCombat.modLoc("textures/model/gauntlet/gauntlet.png");
    }
}

