/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.WeaponMaterial;
import com.userofbricks.expanded_combat.config.WeaponMaterialConfig;
import com.userofbricks.expanded_combat.entity.attributes.RandedDamageAttribute;
import com.userofbricks.expanded_combat.item.ECWeaponItem;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ElementalWeapon
extends ECWeaponItem {
    public final RegistryObject<RandedDamageAttribute> damageAttributeRegistryObject;
    private final double addedDamage;

    public ElementalWeapon(Material material, WeaponMaterial weapon, Item.Properties properties, RegistryObject<RandedDamageAttribute> damageAttributeRegistryObject) {
        this(material, weapon, properties, 0, damageAttributeRegistryObject);
    }

    public ElementalWeapon(Material material, WeaponMaterial weapon, Item.Properties properties, int addedDmg, RegistryObject<RandedDamageAttribute> damageAttributeRegistryObject) {
        super(material, weapon, properties, 0);
        this.damageAttributeRegistryObject = damageAttributeRegistryObject;
        this.addedDamage = addedDmg;
    }

    @Override
    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", this.addedDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)this.damageAttributeRegistryObject.get()), (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getWeapon().config().attackSpeed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER, "Weapon modifier", (double)this.getWeapon().config().knockback, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(ATTACK_REACH_MODIFIER, "Weapon modifier", this.getWeapon().config().attackRange, AttributeModifier.Operation.ADDITION));
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return builder.build();
        }
        if (this.getWeapon().config().wieldType == WeaponMaterialConfig.WieldingType.DUALWIELD && equipmentSlot == EquipmentSlot.OFFHAND) {
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }

    public static class HasPotion
    extends ElementalWeapon {
        public HasPotion(Material material, WeaponMaterial weapon, Item.Properties builderIn, int addedDmg, RegistryObject<RandedDamageAttribute> damageAttributeRegistryObject) {
            super(material, weapon, builderIn, addedDmg, damageAttributeRegistryObject);
        }

        public HasPotion(Material material, WeaponMaterial weapon, Item.Properties builderIn, RegistryObject<RandedDamageAttribute> damageAttributeRegistryObject) {
            this(material, weapon, builderIn, 0, damageAttributeRegistryObject);
        }

        @Override
        public boolean m_7579_(@NotNull ItemStack weapon, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
            if (PotionUtils.m_43579_((ItemStack)weapon) != Potions.f_43598_) {
                for (MobEffectInstance effectInstance : PotionUtils.m_43579_((ItemStack)weapon).m_43488_()) {
                    MobEffectInstance potionEffect = new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_() / 2, effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_());
                    target.m_7292_(potionEffect);
                    List collection = PotionUtils.m_43571_((ItemStack)weapon);
                    if (collection.isEmpty()) continue;
                    for (MobEffectInstance mobeffectinstance : collection) {
                        target.m_7292_(new MobEffectInstance(mobeffectinstance));
                    }
                }
            }
            return super.m_7579_(weapon, target, attacker);
        }

        @NotNull
        public ItemStack m_7968_() {
            return PotionUtils.m_43549_((ItemStack)super.m_7968_(), (Potion)Potions.f_43598_);
        }
    }

    public static class Dyeable
    extends ElementalWeapon
    implements DyeableLeatherItem {
        public Dyeable(Material material, WeaponMaterial weapon, Item.Properties builderIn, int addedDmg, RegistryObject<RandedDamageAttribute> damageAttributeRegistryObject) {
            super(material, weapon, builderIn, addedDmg, damageAttributeRegistryObject);
        }

        public Dyeable(Material material, WeaponMaterial weapon, Item.Properties builderIn, RegistryObject<RandedDamageAttribute> damageAttributeRegistryObject) {
            this(material, weapon, builderIn, 0, damageAttributeRegistryObject);
        }
    }
}

