/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.WeaponMaterial;
import com.userofbricks.expanded_combat.config.WeaponMaterialConfig;
import com.userofbricks.expanded_combat.init.ECEnchantments;
import com.userofbricks.expanded_combat.item.ECHammerWeaponItem;
import com.userofbricks.expanded_combat.item.ISimpleMaterialItem;
import com.userofbricks.expanded_combat.plugins.VanillaECPlugin;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class ECWeaponItem
extends SwordItem
implements ISimpleMaterialItem {
    private final Material material;
    private final WeaponMaterial weapon;
    protected static final UUID ATTACK_KNOCKBACK_MODIFIER = UUID.fromString("a3617883-03fa-4538-a821-7c0a506e8c56");
    protected static final UUID ATTACK_REACH_MODIFIER = UUID.fromString("bc644060-615a-4259-a648-5367cd0d45fa");
    public int hitsTillSlam = 0;

    public ECWeaponItem(Material material, WeaponMaterial weapon, Item.Properties properties) {
        this(material, weapon, properties, 0);
    }

    public ECWeaponItem(final Material material, final WeaponMaterial weapon, Item.Properties properties, int addedDmg) {
        super(new Tier(){

            public int m_6609_() {
                return (int)((double)material.getConfig().durability.toolDurability * weapon.config().durabilityMultiplier);
            }

            public float m_6624_() {
                return 0.0f;
            }

            public float m_6631_() {
                return (float)material.getConfig().offense.addedAttackDamage;
            }

            public int m_6604_() {
                return 0;
            }

            public int m_6601_() {
                return material.getConfig().enchanting.offenseEnchantability;
            }

            @NotNull
            public Ingredient m_6282_() {
                return IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem);
            }
        }, 3 + weapon.config().baseAttackDamage + addedDmg, weapon.config().attackSpeed, properties);
        this.material = material;
        this.weapon = weapon;
    }

    public Material getMaterial() {
        return this.material;
    }

    public WeaponMaterial getWeapon() {
        return this.weapon;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.weapon.config().attackSpeed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER, "Weapon modifier", (double)this.weapon.config().knockback, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(ATTACK_REACH_MODIFIER, "Weapon modifier", this.weapon.config().attackRange, AttributeModifier.Operation.ADDITION));
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return builder.build();
        }
        if (this.weapon.config().wieldType == WeaponMaterialConfig.WieldingType.DUALWIELD && equipmentSlot == EquipmentSlot.OFFHAND) {
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }

    @Override
    public float getMendingBonus() {
        return this.material.getConfig().mendingBonus + this.weapon.config().mendingBonus;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.getMendingBonus();
    }

    public boolean m_7579_(@NotNull ItemStack weapon, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        if (this.getWeapon() == VanillaECPlugin.GREAT_HAMMER || this.getWeapon() == VanillaECPlugin.BROAD_SWORD || this.getWeapon() == VanillaECPlugin.CLAYMORE) {
            ++this.hitsTillSlam;
            int slamLevel = weapon.getEnchantmentLevel((Enchantment)ECEnchantments.GROUND_SLAM.get());
            if (this.hitsTillSlam >= 10 - slamLevel / 2 && slamLevel > 0) {
                this.hitsTillSlam = 0;
                int range = 2 + Math.round((float)slamLevel / 3.0f);
                for (int rDistance = 2; rDistance <= range; ++rDistance) {
                    ECHammerWeaponItem.GroundSlam(1.25f, rDistance, 1.0f, 0.0f, true, 0.1f, attacker, slamLevel);
                }
            }
        }
        return super.m_7579_(weapon, target, attacker);
    }

    public static class HasPotion
    extends ECWeaponItem {
        public HasPotion(Material material, WeaponMaterial weapon, Item.Properties builderIn) {
            super(material, weapon, builderIn);
        }

        @Override
        public boolean m_7579_(@NotNull ItemStack weapon, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
            CompoundTag compoundTag = weapon.m_41784_();
            int potionUses = compoundTag.m_128451_("PotionUses");
            if (PotionUtils.m_43579_((ItemStack)weapon) != Potions.f_43598_ && potionUses >= 1) {
                if (potionUses == 1) {
                    PotionUtils.m_43549_((ItemStack)weapon, (Potion)Potions.f_43598_);
                    PotionUtils.m_43552_((ItemStack)weapon, (Collection)Lists.newArrayList());
                }
                compoundTag.m_128405_("PotionUses", potionUses - 1);
                for (MobEffectInstance effectInstance : PotionUtils.m_43579_((ItemStack)weapon).m_43488_()) {
                    target.m_7292_(effectInstance);
                    List collection = PotionUtils.m_43571_((ItemStack)weapon);
                    if (collection.isEmpty()) continue;
                    for (MobEffectInstance mobeffectinstance : collection) {
                        target.m_7292_(new MobEffectInstance(mobeffectinstance));
                    }
                }
            } else {
                PotionUtils.m_43549_((ItemStack)weapon, (Potion)Potions.f_43598_);
                PotionUtils.m_43552_((ItemStack)weapon, (Collection)Lists.newArrayList());
            }
            return super.m_7579_(weapon, target, attacker);
        }

        @NotNull
        public ItemStack m_7968_() {
            ItemStack stack = PotionUtils.m_43549_((ItemStack)super.m_7968_(), (Potion)Potions.f_43598_);
            stack.m_41784_().m_128405_("PotionUses", 0);
            stack.m_41784_().m_128405_("MaxPotionUses", 0);
            return stack;
        }
    }

    public static class Dyeable
    extends ECWeaponItem
    implements DyeableLeatherItem {
        public Dyeable(Material material, WeaponMaterial weapon, Item.Properties builderIn) {
            super(material, weapon, builderIn);
        }
    }
}

