/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item;

import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.registry.ShieldMaterialUseTick;
import com.userofbricks.expanded_combat.client.renderer.item.ECShieldBlockEntityWithoutLevelRenderer;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ECShieldItem
extends ShieldItem {
    public static final String ULMaterialTagName = "UL_Material";
    public static final String URMaterialTagName = "UR_Material";
    public static final String DLMaterialTagName = "DL_Material";
    public static final String DRMaterialTagName = "DR_Material";
    public static final String MMaterialTagName = "M_Material";
    public static final String LastRepairNumber = "Last_Repair_Number";

    public ECShieldItem(boolean fireresistant, Item.Properties properties) {
        super(fireresistant ? properties.m_41486_().m_41487_(1) : properties.m_41487_(1));
    }

    @Nonnull
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        stack.m_41784_().m_128359_(ULMaterialTagName, "empty");
        stack.m_41784_().m_128359_(URMaterialTagName, "empty");
        stack.m_41784_().m_128359_(DLMaterialTagName, "empty");
        stack.m_41784_().m_128359_(DRMaterialTagName, "empty");
        stack.m_41784_().m_128359_(MMaterialTagName, "empty");
        stack.m_41784_().m_128405_(LastRepairNumber, 0);
        return stack;
    }

    public int getMaxDamage(ItemStack stack) {
        int durability = 336;
        int ul = MaterialInit.valueOfShield((String)"ul", (String)ECShieldItem.getUpperLeftMaterial((ItemStack)stack)).getConfig().durability.addedShieldDurability;
        int ur = MaterialInit.valueOfShield((String)"ur", (String)ECShieldItem.getUpperRightMaterial((ItemStack)stack)).getConfig().durability.addedShieldDurability;
        int dl = MaterialInit.valueOfShield((String)"dl", (String)ECShieldItem.getDownLeftMaterial((ItemStack)stack)).getConfig().durability.addedShieldDurability;
        int dr = MaterialInit.valueOfShield((String)"dr", (String)ECShieldItem.getDownRightMaterial((ItemStack)stack)).getConfig().durability.addedShieldDurability;
        int m = MaterialInit.valueOfShield((String)"m", (String)ECShieldItem.getMiddleMaterial((ItemStack)stack)).getConfig().durability.addedShieldDurability;
        return durability + ul + ur + dl + dr + m;
    }

    public boolean m_41465_() {
        return true;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        if (repair.m_41720_() instanceof EnchantedBookItem) {
            return false;
        }
        String ul = ECShieldItem.getUpperLeftMaterial(toRepair);
        String ur = ECShieldItem.getUpperRightMaterial(toRepair);
        String dl = ECShieldItem.getDownLeftMaterial(toRepair);
        String dr = ECShieldItem.getDownRightMaterial(toRepair);
        String m = ECShieldItem.getMiddleMaterial(toRepair);
        int last = toRepair.m_41784_().m_128451_(LastRepairNumber) + 1;
        if (last >= 5) {
            last = 0;
        }
        List<String> slotMaterials = Arrays.asList(ul, ur, dl, dr, m);
        String currentSlotMaterial = slotMaterials.get(last);
        toRepair.m_41784_().m_128405_(LastRepairNumber, last);
        Ingredient ingredient = IngredientUtil.getIngrediantFromItemString(MaterialInit.valueOfShield((String)"any", (String)currentSlotMaterial).getConfig().crafting.repairItem);
        return !ingredient.m_43947_() && ingredient.test(repair);
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.getMendingBonus(stack);
    }

    public float getMendingBonus(ItemStack stack) {
        float ul = MaterialInit.valueOfShield((String)"ul", (String)ECShieldItem.getUpperLeftMaterial((ItemStack)stack)).getConfig().mendingBonus / 5.0f;
        float ur = MaterialInit.valueOfShield((String)"ur", (String)ECShieldItem.getUpperRightMaterial((ItemStack)stack)).getConfig().mendingBonus / 5.0f;
        float dl = MaterialInit.valueOfShield((String)"dl", (String)ECShieldItem.getDownLeftMaterial((ItemStack)stack)).getConfig().mendingBonus / 5.0f;
        float dr = MaterialInit.valueOfShield((String)"dr", (String)ECShieldItem.getDownRightMaterial((ItemStack)stack)).getConfig().mendingBonus / 5.0f;
        float m = MaterialInit.valueOfShield((String)"m", (String)ECShieldItem.getMiddleMaterial((ItemStack)stack)).getConfig().mendingBonus / 5.0f;
        return ul + ur + dl + dr + m;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        String ul = ECShieldItem.getUpperLeftMaterial(stack);
        String ur = ECShieldItem.getUpperRightMaterial(stack);
        String dl = ECShieldItem.getDownLeftMaterial(stack);
        String dr = ECShieldItem.getDownRightMaterial(stack);
        String m = ECShieldItem.getMiddleMaterial(stack);
        list.add((Component)Component.m_237115_((String)"tooltip.expanded_combat.shield_material.upper_left").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)Component.m_237115_((String)("tooltip.expanded_combat.shield_material." + ul)).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        list.add((Component)Component.m_237115_((String)"tooltip.expanded_combat.shield_material.upper_right").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)Component.m_237115_((String)("tooltip.expanded_combat.shield_material." + ur)).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        list.add((Component)Component.m_237115_((String)"tooltip.expanded_combat.shield_material.pegs_trim").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)Component.m_237115_((String)("tooltip.expanded_combat.shield_material." + m)).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        list.add((Component)Component.m_237115_((String)"tooltip.expanded_combat.shield_material.lower_left").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)Component.m_237115_((String)("tooltip.expanded_combat.shield_material." + dl)).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        list.add((Component)Component.m_237115_((String)"tooltip.expanded_combat.shield_material.lower_right").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)Component.m_237115_((String)("tooltip.expanded_combat.shield_material." + dr)).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        if (this.getMendingBonus(stack) != 0.0f) {
            if (this.getMendingBonus(stack) > 0.0f) {
                list.add(1, (Component)Component.m_237115_((String)"tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)(ChatFormatting.BLUE + " " + ItemStack.f_41584_.format(this.getMendingBonus(stack))))));
            } else if (this.getMendingBonus(stack) < 0.0f) {
                list.add(1, (Component)Component.m_237115_((String)"tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)(ChatFormatting.RED + " " + ItemStack.f_41584_.format(this.getMendingBonus(stack))))));
            }
        }
        super.m_7373_(stack, world, list, flag);
    }

    public static double getBaseProtection(ItemStack stack) {
        double ul = MaterialInit.valueOfShield((String)"ul", (String)ECShieldItem.getUpperLeftMaterial((ItemStack)stack)).getConfig().defense.baseProtectionAmmount / 5.0f;
        double ur = MaterialInit.valueOfShield((String)"ur", (String)ECShieldItem.getUpperRightMaterial((ItemStack)stack)).getConfig().defense.baseProtectionAmmount / 5.0f;
        double dl = MaterialInit.valueOfShield((String)"dl", (String)ECShieldItem.getDownLeftMaterial((ItemStack)stack)).getConfig().defense.baseProtectionAmmount / 5.0f;
        double dr = MaterialInit.valueOfShield((String)"dr", (String)ECShieldItem.getDownRightMaterial((ItemStack)stack)).getConfig().defense.baseProtectionAmmount / 5.0f;
        double m = MaterialInit.valueOfShield((String)"m", (String)ECShieldItem.getMiddleMaterial((ItemStack)stack)).getConfig().defense.baseProtectionAmmount / 5.0f;
        return ul + ur + dl + dr + m;
    }

    public static double getPercentageProtection(ItemStack stack) {
        double ul = MaterialInit.valueOfShield((String)"ul", (String)ECShieldItem.getUpperLeftMaterial((ItemStack)stack)).getConfig().defense.afterBasePercentReduction / 5.0f;
        double ur = MaterialInit.valueOfShield((String)"ur", (String)ECShieldItem.getUpperRightMaterial((ItemStack)stack)).getConfig().defense.afterBasePercentReduction / 5.0f;
        double dl = MaterialInit.valueOfShield((String)"dl", (String)ECShieldItem.getDownLeftMaterial((ItemStack)stack)).getConfig().defense.afterBasePercentReduction / 5.0f;
        double dr = MaterialInit.valueOfShield((String)"dr", (String)ECShieldItem.getDownRightMaterial((ItemStack)stack)).getConfig().defense.afterBasePercentReduction / 5.0f;
        double m = MaterialInit.valueOfShield((String)"m", (String)ECShieldItem.getMiddleMaterial((ItemStack)stack)).getConfig().defense.afterBasePercentReduction / 5.0f;
        return ul + ur + dl + dr + m;
    }

    public static double getShieldToMaterialBaseProtection(ItemStack stack) {
        double ul = MaterialInit.getMaterialForShieldPart((String)"ul", (ItemLike)stack.m_41720_()).getConfig().defense.baseProtectionAmmount / 5.0f;
        double ur = MaterialInit.getMaterialForShieldPart((String)"ur", (ItemLike)stack.m_41720_()).getConfig().defense.baseProtectionAmmount / 5.0f;
        double dl = MaterialInit.getMaterialForShieldPart((String)"dl", (ItemLike)stack.m_41720_()).getConfig().defense.baseProtectionAmmount / 5.0f;
        double dr = MaterialInit.getMaterialForShieldPart((String)"dr", (ItemLike)stack.m_41720_()).getConfig().defense.baseProtectionAmmount / 5.0f;
        double m = MaterialInit.getMaterialForShieldPart((String)"m", (ItemLike)stack.m_41720_()).getConfig().defense.baseProtectionAmmount / 5.0f;
        return ul + ur + dl + dr + m;
    }

    public static double getShieldToMaterialPercentageProtection(ItemStack stack) {
        double ul = MaterialInit.getMaterialForShieldPart((String)"ul", (ItemLike)stack.m_41720_()).getConfig().defense.afterBasePercentReduction / 5.0f;
        double ur = MaterialInit.getMaterialForShieldPart((String)"ur", (ItemLike)stack.m_41720_()).getConfig().defense.afterBasePercentReduction / 5.0f;
        double dl = MaterialInit.getMaterialForShieldPart((String)"dl", (ItemLike)stack.m_41720_()).getConfig().defense.afterBasePercentReduction / 5.0f;
        double dr = MaterialInit.getMaterialForShieldPart((String)"dr", (ItemLike)stack.m_41720_()).getConfig().defense.afterBasePercentReduction / 5.0f;
        double m = MaterialInit.getMaterialForShieldPart((String)"m", (ItemLike)stack.m_41720_()).getConfig().defense.afterBasePercentReduction / 5.0f;
        return ul + ur + dl + dr + m;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ECShieldBlockEntityWithoutLevelRenderer();
            }
        });
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44975_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int timeUsing) {
        super.m_5929_(level, livingEntity, itemStack, timeUsing);
        HashMap<Material, Integer> materials = new HashMap<Material, Integer>();
        for (Material material : Arrays.asList(MaterialInit.valueOfShield("ul", ECShieldItem.getUpperLeftMaterial(itemStack)), MaterialInit.valueOfShield("ur", ECShieldItem.getUpperRightMaterial(itemStack)), MaterialInit.valueOfShield("m", ECShieldItem.getMiddleMaterial(itemStack)), MaterialInit.valueOfShield("dl", ECShieldItem.getDownLeftMaterial(itemStack)), MaterialInit.valueOfShield("dr", ECShieldItem.getDownRightMaterial(itemStack)))) {
            if (materials.containsKey(material)) {
                materials.replace(material, (Integer)materials.get(material) + 1);
                continue;
            }
            materials.put(material, 1);
        }
        for (Map.Entry entry : materials.entrySet()) {
            ShieldMaterialUseTick useTick = MaterialInit.getShieldHaveUseTickEntry((Material)entry.getKey());
            if (useTick == null) continue;
            useTick.onUseTick().apply(level, livingEntity, itemStack, timeUsing, (Integer)entry.getValue());
        }
    }

    public static String getUpperLeftMaterial(ItemStack stack) {
        return stack.m_41784_().m_128461_(ULMaterialTagName);
    }

    public static String getUpperRightMaterial(ItemStack stack) {
        return stack.m_41784_().m_128461_(URMaterialTagName);
    }

    public static String getDownLeftMaterial(ItemStack stack) {
        return stack.m_41784_().m_128461_(DLMaterialTagName);
    }

    public static String getDownRightMaterial(ItemStack stack) {
        return stack.m_41784_().m_128461_(DRMaterialTagName);
    }

    public static String getMiddleMaterial(ItemStack stack) {
        return stack.m_41784_().m_128461_(MMaterialTagName);
    }

    public static ItemStack makeShieldBeMaterial(ItemStack stack, Material material) {
        stack.m_41784_().m_128359_(ULMaterialTagName, material.getLocationName().toString());
        stack.m_41784_().m_128359_(URMaterialTagName, material.getLocationName().toString());
        stack.m_41784_().m_128359_(DLMaterialTagName, material.getLocationName().toString());
        stack.m_41784_().m_128359_(DRMaterialTagName, material.getLocationName().toString());
        stack.m_41784_().m_128359_(MMaterialTagName, material.getLocationName().toString());
        return stack;
    }
}

