/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item;

import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.client.renderer.QuiverRenderer;
import com.userofbricks.expanded_combat.init.ECKeyRegistry;
import com.userofbricks.expanded_combat.network.ECVariables;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class ECQuiverItem
extends Item
implements ICurioItem {
    private final ResourceLocation QUIVER_TEXTURE;
    public final int providedSlots;
    public final Material material;

    public ECQuiverItem(Item.Properties properties, Material material) {
        super(properties);
        this.QUIVER_TEXTURE = new ResourceLocation("expanded_combat", "textures/entity/quiver/" + material.getLocationName().m_135815_() + ".png");
        this.providedSlots = material.getConfig().quiverSlots;
        this.material = material;
    }

    public ResourceLocation getQUIVER_TEXTURE() {
        return this.QUIVER_TEXTURE;
    }

    public Supplier<ICurioRenderer> getQuiverRenderer() {
        return QuiverRenderer::new;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(curios -> {
            IDynamicStackHandler stackHandler = ((ICurioStacksHandler)curios.getCurios().get("arrows")).getStacks();
            if (livingEntity.m_9236_().m_5776_()) {
                int countdownTicks = stack.m_41784_().m_128451_("countdown_ticks");
                if (countdownTicks > 0) {
                    stack.m_41784_().m_128405_("countdown_ticks", countdownTicks - 1);
                } else if (ECKeyRegistry.cycleQuiverLeft.m_90857_() && countdownTicks == 0) {
                    this.sycleArrows(livingEntity, (IItemHandler)stackHandler, false);
                    stack.m_41784_().m_128405_("countdown_ticks", 5);
                } else if (ECKeyRegistry.cycleQuiverRight.m_90857_() && countdownTicks == 0) {
                    this.sycleArrows(livingEntity, (IItemHandler)stackHandler, true);
                    stack.m_41784_().m_128405_("countdown_ticks", 5);
                }
            }
        });
    }

    public void sycleArrows(LivingEntity livingEntity, IItemHandler itemHandler, boolean forward) {
        int arrowSlot = ECVariables.getArrowSlot((Entity)livingEntity);
        for (int check = 0; check < this.providedSlots; ++check) {
            if ((arrowSlot += forward ? 1 : -1) >= this.providedSlots) {
                arrowSlot = 0;
            }
            if (arrowSlot < 0) {
                arrowSlot = this.providedSlots - 1;
            }
            if (!itemHandler.getStackInSlot(arrowSlot).m_41619_()) break;
        }
        ECVariables.setArrowSlotTo(livingEntity, arrowSlot);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return this.material.getName().equals("Gold");
    }
}

