/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item;

import com.userofbricks.expanded_combat.ExpandedCombat;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.init.ECEnchantments;
import com.userofbricks.expanded_combat.item.ECWeaponItem;
import com.userofbricks.expanded_combat.network.ECVariables;
import com.userofbricks.expanded_combat.plugins.VanillaECPlugin;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ECKatanaItem
extends ECWeaponItem {
    public ECKatanaItem(Material material, Item.Properties properties) {
        super(material, VanillaECPlugin.KATANA, properties);
    }

    public static int getMaxBlocksInARow(ItemStack katanaStack) {
        if (katanaStack.m_41720_() instanceof ECKatanaItem) {
            return ExpandedCombat.CONFIG.enchantmentLevels.baseKatanaArrowBlocks + katanaStack.getEnchantmentLevel((Enchantment)ECEnchantments.BLOCKING.get());
        }
        return 0;
    }

    public static boolean blockedRecently(LivingEntity livingEntity) {
        int timeSinceBlock = ECVariables.getKatanaTimeSinceBlock((Entity)livingEntity);
        return timeSinceBlock < 20;
    }

    public static float blockPosition(ItemStack itemStack) {
        if (itemStack.m_41784_().m_128441_("BlockingPos")) {
            return itemStack.m_41784_().m_128457_("BlockingPos");
        }
        return 0.0f;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41784_();
        if (compoundtag.m_128441_("BlockingPos")) {
            float pos = compoundtag.m_128457_("BlockingPos");
            if (pos == 0.0f) {
                return UseAnim.BLOCK;
            }
            if ((double)pos == 0.1) {
                return UseAnim.BLOCK;
            }
            if ((double)pos == 0.2) {
                return UseAnim.BLOCK;
            }
            if ((double)pos == 0.3) {
                return UseAnim.BLOCK;
            }
            if ((double)pos == 0.4) {
                return UseAnim.NONE;
            }
        }
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    @Override
    public boolean m_7579_(ItemStack p_43278_, LivingEntity p_43279_, LivingEntity p_43280_) {
        return super.m_7579_(p_43278_, p_43279_, p_43280_);
    }
}

