/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item;

import com.userofbricks.expanded_combat.ExpandedCombat;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.enchantments.GroundSlamEnchantment;
import com.userofbricks.expanded_combat.entity.ECFallingBlockEntity;
import com.userofbricks.expanded_combat.item.ECWeaponItem;
import com.userofbricks.expanded_combat.plugins.VanillaECPlugin;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ECHammerWeaponItem
extends ECWeaponItem {
    public ECHammerWeaponItem(Material material, Item.Properties properties) {
        super(material, VanillaECPlugin.GREAT_HAMMER, properties);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return super.getEnchantmentLevel(stack, enchantment) + (enchantment instanceof GroundSlamEnchantment ? ExpandedCombat.CONFIG.enchantmentLevels.baseHammerSlamLevel : 0);
    }

    protected static void GroundSlam(float spreadarc, int distance, float maxy, float vec, boolean grab, float airborne, @NotNull LivingEntity attacker, int slamLevel) {
        float dmg = (float)(attacker.m_21133_(Attributes.f_22281_) * 0.9);
        dmg += dmg * 0.05f * (float)(slamLevel - 1);
        double perpFacing = (double)attacker.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(attacker.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        double minY = attacker.m_20186_() - 1.0;
        double maxY = attacker.m_20186_() + (double)maxy;
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = attacker.m_20185_() + vx * (double)distance + (double)vec * Math.cos((double)(attacker.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = attacker.m_20189_() + vz * (double)distance + (double)vec * Math.sin((double)(attacker.f_20883_ + 90.0f) * Math.PI / 180.0);
            float factor = 1.0f - (float)distance / 12.0f;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
            BlockState block = attacker.m_9236_().m_8055_(pos);
            BlockState blockAbove = attacker.m_9236_().m_8055_(abovePos);
            if (block != Blocks.f_50016_.m_49966_() && !block.m_155947_() && !blockAbove.m_280555_()) {
                ECFallingBlockEntity fallingBlockEntity = new ECFallingBlockEntity(attacker.m_9236_(), (double)hitX + 0.5, (double)hitY + 1.125, (double)hitZ + 0.5, block, 10);
                fallingBlockEntity.m_5997_(0.0, 0.075 + attacker.m_217043_().m_188583_() * 0.07, 0.0);
                attacker.m_9236_().m_7967_((Entity)fallingBlockEntity);
            }
            AABB selection = new AABB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
            List hit = attacker.m_9236_().m_45976_(LivingEntity.class, selection);
            for (LivingEntity entity : hit) {
                boolean flag;
                DamageSource damageSource;
                if (attacker.m_7307_((Entity)entity) || entity == attacker) continue;
                DamageSources damageSources = attacker.m_269291_();
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    damageSource = damageSources.m_269075_(player);
                } else {
                    damageSource = damageSources.m_269333_(attacker);
                }
                if (!(flag = entity.m_6469_(damageSource, dmg))) continue;
                if (grab) {
                    double magnitude = -4.0;
                    double x = vx * (double)(1.0f - factor) * magnitude;
                    double y = 0.0;
                    if (entity.m_20096_()) {
                        y += 0.15;
                    }
                    double z = vz * (double)(1.0f - factor) * magnitude;
                    entity.m_20256_(entity.m_20184_().m_82520_(x, y, z));
                    continue;
                }
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)(airborne * (float)distance) + attacker.m_9236_().f_46441_.m_188500_() * 0.15, 0.0));
            }
        }
    }
}

