/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.client.renderer.GauntletRenderer;
import com.userofbricks.expanded_combat.init.ECAttributes;
import com.userofbricks.expanded_combat.init.ECEnchantments;
import com.userofbricks.expanded_combat.item.ISimpleMaterialItem;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ECGauntletItem
extends Item
implements ICurioItem,
ISimpleMaterialItem {
    private final ResourceLocation GAUNTLET_TEXTURE;
    private final Material material;
    protected static final UUID ATTACK_UUID = UUID.fromString("7ce10414-adcc-4bf2-8804-f5dbd39fadaf");
    protected static final UUID ARMOR_UUID = UUID.fromString("38faf191-bf78-4654-b349-cc1f4f1143bf");
    protected static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("b64fd3d6-a9fe-46a1-a972-90e4b0849678");
    protected static final UUID KNOCKBACK_UUID = UUID.fromString("a3617883-03fa-4538-a821-7c0a506e8c56");
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){

        @NotNull
        protected ItemStack m_7498_(@NotNull BlockSource blockSource, @NotNull ItemStack itemStack) {
            return ECGauntletItem.dispenseGauntlet(blockSource, itemStack) ? itemStack : super.m_7498_(blockSource, itemStack);
        }
    };

    public static boolean dispenseGauntlet(BlockSource blockSource, ItemStack stack) {
        BlockPos blockpos = blockSource.m_7961_().m_121945_((Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        List list = blockSource.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), EntitySelector.f_20408_.and(new EntitySelector.MobCanWearArmorEntitySelector(stack)));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)list.get(0);
        Optional optionalSlotResult = CuriosApi.getCuriosHelper().findCurio(livingentity, "hands", 0);
        if (optionalSlotResult.isPresent() && !((SlotResult)optionalSlotResult.get()).stack().m_41619_()) {
            return false;
        }
        ItemStack itemstack = stack.m_41620_(1);
        CuriosApi.getCuriosHelper().setEquippedCurio(livingentity, "hands", 0, itemstack);
        if (livingentity instanceof Mob) {
            ((Mob)livingentity).m_21530_();
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public ECGauntletItem(Item.Properties properties, Material materialIn) {
        super(properties);
        this.material = materialIn;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
        this.GAUNTLET_TEXTURE = new ResourceLocation("expanded_combat", "textures/model/gauntlet/" + materialIn.getLocationName().m_135815_() + ".png");
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.material.getConfig().enchanting.offenseEnchantability / 2 + this.material.getConfig().enchanting.defenseEnchantability / 2;
    }

    public boolean m_6832_(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return IngredientUtil.getIngrediantFromItemString(this.material.getConfig().crafting.repairItem).test(repair) || super.m_6832_(toRepair, repair);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getConfig().durability.toolDurability;
    }

    public boolean m_41465_() {
        return true;
    }

    public boolean m_41475_() {
        return this.material.getConfig().fireResistant;
    }

    public boolean m_41386_(@NotNull DamageSource damageSource) {
        return !this.material.getConfig().fireResistant || !damageSource.m_269533_(DamageTypeTags.f_268745_);
    }

    @Override
    public float getMendingBonus() {
        return this.material.getConfig().mendingBonus;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.getMendingBonus();
    }

    public int getArmorAmount() {
        return this.material.getConfig().defense.gauntletArmorAmount;
    }

    public double getAttackDamage() {
        return this.material.getConfig().offense.addedAttackDamage;
    }

    public ResourceLocation getGauntletTexture(ItemStack stack) {
        return this.GAUNTLET_TEXTURE;
    }

    public boolean hasEmissiveTexture(ItemStack stack) {
        return false;
    }

    public ResourceLocation getEmissiveTexture(ItemStack stack) {
        return new ResourceLocation("null");
    }

    public Supplier<ICurioRenderer> getGauntletRenderer() {
        return GauntletRenderer::new;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return ((ECGauntletItem)stack.m_41720_()).getMaterial().getName().equals("Gold");
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(this.material.getConfig().equipSound))), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap atts = HashMultimap.create();
        double totalBaseDamage = Math.max(((ECGauntletItem)stack.m_41720_()).getAttackDamage(), 0.5);
        float totalExtraDamage = ((ECGauntletItem)stack.m_41720_()).getMaterial().getAdditionalDamageAfterEnchantments().apply(Float.valueOf((float)totalBaseDamage)).floatValue();
        double totalEnchantedDamage = stack.getEnchantmentLevel(Enchantments.f_44989_);
        atts.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ATTACK_UUID, "Attack damage bonus", (totalBaseDamage + totalEnchantedDamage + (double)totalExtraDamage) / 2.0, AttributeModifier.Operation.ADDITION));
        atts.put((Object)((Attribute)ECAttributes.GAUNTLET_DMG_WITHOUT_WEAPON.get()), (Object)new AttributeModifier(ATTACK_UUID, "Attack damage bonus", (totalBaseDamage + (double)totalExtraDamage) / 2.0 + totalEnchantedDamage, AttributeModifier.Operation.ADDITION));
        atts.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_UUID, "Armor bonus", (double)((ECGauntletItem)stack.m_41720_()).getArmorAmount(), AttributeModifier.Operation.ADDITION));
        double toughness = ((ECGauntletItem)stack.m_41720_()).getMaterial().getConfig().defense.armorToughness;
        atts.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_UUID, "Armor Toughness bonus", toughness, AttributeModifier.Operation.ADDITION));
        double knockbackResistance = ((ECGauntletItem)stack.m_41720_()).getMaterial().getConfig().defense.knockbackResistance;
        atts.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback resistance bonus", knockbackResistance + (double)((float)stack.getEnchantmentLevel((Enchantment)ECEnchantments.KNOCKBACK_RESISTANCE.get()) / 10.0f), AttributeModifier.Operation.ADDITION));
        atts.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(KNOCKBACK_UUID, "Knockback bonus", (double)stack.getEnchantmentLevel(Enchantments.f_44980_), AttributeModifier.Operation.ADDITION));
        if (stack.getEnchantmentLevel((Enchantment)ECEnchantments.AGILITY.get()) > 0) {
            atts.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("33dad864-864b-4dbd-acae-88b72cc358cf"), "Agility Attack Speed", (double)stack.getEnchantmentLevel((Enchantment)ECEnchantments.AGILITY.get()) * 0.02, AttributeModifier.Operation.ADDITION));
        }
        return atts;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44980_ || enchantment == Enchantments.f_44989_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public static class Dyeable
    extends ECGauntletItem
    implements DyeableLeatherItem {
        private final ResourceLocation GAUNTLET_TEXTURE_OVERLAY;

        public Dyeable(Item.Properties properties, Material materialIn) {
            super(properties, materialIn);
            this.GAUNTLET_TEXTURE_OVERLAY = new ResourceLocation("expanded_combat", "textures/model/gauntlet/" + materialIn.getLocationName().m_135815_() + "_overlay.png");
        }

        @Deprecated(forRemoval=true, since="3.0.1 will be removed in 4.0.0")
        public ResourceLocation getGAUNTLET_TEXTURE_OVERLAY(ItemStack stack) {
            return this.GAUNTLET_TEXTURE_OVERLAY;
        }

        public ResourceLocation getGauntletTextureOverlay(ItemStack stack) {
            return this.getGAUNTLET_TEXTURE_OVERLAY(stack);
        }
    }
}

