/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.item;

import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.item.ISimpleMaterialItem;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class ECBowItem
extends BowItem
implements ISimpleMaterialItem {
    public final Material material;
    @Nullable
    public final Material previosMaterial;

    public ECBowItem(Item.Properties builder, Material material, @Nullable Material previosMaterial) {
        super(builder);
        this.material = material;
        this.previosMaterial = previosMaterial;
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerentity = (Player)entityLiving;
            boolean useInfiniteAmmo = playerentity.m_150110_().f_35937_ || stack.getEnchantmentLevel(Enchantments.f_44952_) > 0;
            ItemStack itemstack = playerentity.m_6298_(stack);
            int charge = this.m_8105_(stack) - timeLeft;
            if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)worldIn, (Player)playerentity, (int)charge, (!itemstack.m_41619_() || useInfiniteAmmo ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || useInfiniteAmmo) {
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                float arrowVelocity = this.getBowArrowVelocity(stack, charge);
                this.fireArrows(stack, worldIn, playerentity, itemstack, arrowVelocity);
            }
        }
    }

    private int getMultishotLevel() {
        if (this.previosMaterial != null) {
            return this.material.getConfig().offense.multishotLevel / 2 + this.previosMaterial.getConfig().offense.multishotLevel / 2;
        }
        return this.material.getConfig().offense.multishotLevel;
    }

    public void fireArrows(ItemStack stack, Level worldIn, Player playerentity, ItemStack itemstack, float arrowVelocity) {
        int multishotLevel = stack.getEnchantmentLevel(Enchantments.f_44959_) + this.getMultishotLevel();
        for (int arrowNumber = 0; arrowNumber < 1 + multishotLevel * 2; ++arrowNumber) {
            boolean isAdditionalShot;
            if (!((double)arrowVelocity >= 0.1)) continue;
            boolean hasInfiniteAmmo = playerentity.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, stack, playerentity);
            boolean bl = isAdditionalShot = arrowNumber > 0;
            if (!worldIn.f_46443_) {
                this.createBowArrow(stack, worldIn, playerentity, itemstack, arrowVelocity, arrowNumber, hasInfiniteAmmo, isAdditionalShot);
            }
            worldIn.m_6263_(null, playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.m_213780_().m_188501_() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
            if (!(hasInfiniteAmmo || playerentity.m_150110_().f_35937_ || isAdditionalShot)) {
                itemstack.m_41774_(1);
                if (itemstack.m_41619_()) {
                    playerentity.m_150109_().m_36057_(itemstack);
                }
            }
            playerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    private int getBowPower() {
        if (this.previosMaterial != null) {
            return this.material.getConfig().offense.bowPower / 2 + this.previosMaterial.getConfig().offense.bowPower / 2;
        }
        return this.material.getConfig().offense.bowPower;
    }

    public void createBowArrow(ItemStack stack, Level worldIn, Player playerentity, ItemStack itemstack, float arrowVelocity, int i, boolean hasInfiniteAmmo, boolean isAdditionalShot) {
        int k;
        int powerLevel;
        ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
        AbstractArrow abstractarrowentity = arrowitem.m_6394_(worldIn, itemstack, (LivingEntity)playerentity);
        abstractarrowentity = this.customArrow(abstractarrowentity);
        this.setArrowTrajectory(playerentity, arrowVelocity, i, abstractarrowentity);
        if (arrowVelocity == 1.0f) {
            abstractarrowentity.m_36762_(true);
        }
        if ((powerLevel = stack.getEnchantmentLevel(Enchantments.f_44988_) + this.getBowPower()) > 0) {
            abstractarrowentity.m_36781_(abstractarrowentity.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((k = stack.getEnchantmentLevel(Enchantments.f_44989_)) > 0) {
            abstractarrowentity.m_36735_(k);
        }
        if (stack.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
            abstractarrowentity.m_20254_(100);
        }
        stack.m_41622_(1, (LivingEntity)playerentity, p_220009_1_ -> p_220009_1_.m_21190_(playerentity.m_7655_()));
        if (hasInfiniteAmmo || playerentity.m_150110_().f_35937_ && (itemstack.m_41720_() == Items.f_42737_ || itemstack.m_41720_() == Items.f_42738_)) {
            abstractarrowentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        if (isAdditionalShot) {
            abstractarrowentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        worldIn.m_7967_((Entity)abstractarrowentity);
    }

    private float getVelocitiMultiplier() {
        if (this.previosMaterial != null) {
            return this.material.getConfig().offense.velocityMultiplier / 2.0f + this.previosMaterial.getConfig().offense.velocityMultiplier / 2.0f;
        }
        return this.material.getConfig().offense.velocityMultiplier;
    }

    public void setArrowTrajectory(Player playerentity, float arrowVelocity, int i, AbstractArrow abstractarrowentity) {
        if (i == 0) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 0.0f, 0.0f, arrowVelocity * this.getVelocitiMultiplier(), 1.0f);
        }
        if (i == 1) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 10.0f, 0.0f, arrowVelocity * this.getVelocitiMultiplier(), 1.0f);
        }
        if (i == 2) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 10.0f, 0.0f, arrowVelocity * this.getVelocitiMultiplier(), 1.0f);
        }
        if (i == 3) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 20.0f, 0.0f, arrowVelocity * this.getVelocitiMultiplier(), 1.0f);
        }
        if (i == 4) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 20.0f, 0.0f, arrowVelocity * this.getVelocitiMultiplier(), 1.0f);
        }
        if (i == 5) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 30.0f, 0.0f, arrowVelocity * this.getVelocitiMultiplier(), 1.0f);
        }
        if (i == 6) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 30.0f, 0.0f, arrowVelocity * this.getVelocitiMultiplier(), 1.0f);
        }
    }

    public float getBowArrowVelocity(ItemStack stack, int charge) {
        float bowChargeTime = this.getBowChargeTime(stack);
        if (bowChargeTime <= 0.0f) {
            bowChargeTime = 1.0f;
        }
        float arrowVelocity = (float)charge / bowChargeTime;
        if ((arrowVelocity = (arrowVelocity * arrowVelocity + arrowVelocity * 2.0f) / 3.0f) > 1.0f) {
            arrowVelocity = 1.0f;
        }
        return arrowVelocity;
    }

    public float getBowChargeTime(ItemStack stack) {
        int quickChargeLevel = stack.getEnchantmentLevel(Enchantments.f_44960_);
        return Math.max(20 - 5 * quickChargeLevel, 0);
    }

    @Override
    public float getMendingBonus() {
        if (this.previosMaterial != null) {
            return this.material.getConfig().mendingBonus / 2.0f + this.previosMaterial.getConfig().mendingBonus / 2.0f;
        }
        return this.material.getConfig().mendingBonus;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.getMendingBonus();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getConfig().durability.bowDurability;
    }

    public boolean m_41465_() {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.material.getConfig().enchanting.offenseEnchantability;
    }

    public boolean m_6832_(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return IngredientUtil.getIngrediantFromItemString(this.material.getConfig().crafting.repairItem).test(repair) || super.m_6832_(toRepair, repair);
    }

    public boolean m_41475_() {
        return this.material.getConfig().fireResistant;
    }

    public boolean m_41386_(@NotNull DamageSource damageSource) {
        return !this.material.getConfig().fireResistant || !damageSource.m_269533_(DamageTypeTags.f_268745_);
    }

    public Material getMaterial() {
        return this.material;
    }

    @Nullable
    public Material getPreviosMaterial() {
        return this.previosMaterial;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        ECBowItem bowItem = (ECBowItem)stack.m_41720_();
        return bowItem.getMaterial().getName().equals("Gold") || bowItem.getPreviosMaterial() != null && bowItem.getPreviosMaterial().getName().equals("Gold");
    }
}

