/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.inventory.container;

import com.mojang.datafixers.util.Pair;
import com.userofbricks.expanded_combat.item.ECQuiverItem;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import top.theillusivec4.curios.api.event.CurioUnequipEvent;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.mixin.core.AccessorEntity;

public class ArrowSlot
extends SlotItemHandler {
    private final Player player;
    private final SlotContext slotContext;

    public ArrowSlot(Player player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition) {
        super((IItemHandler)handler, index, xPosition, yPosition);
        this.player = player;
        this.slotContext = new SlotContext(identifier, (LivingEntity)player, index, false, false);
        this.setBackground(InventoryMenu.f_39692_, player.m_20193_().m_5776_() ? CuriosApi.getIconHelper().getIcon(identifier) : new ResourceLocation("curios", "slot/empty_curio_slot"));
    }

    public SlotContext getSlotContext() {
        return this.slotContext;
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        Item item2;
        SlotResult slotResult = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)this.player, item -> item.m_41720_() instanceof ECQuiverItem).orElse(null);
        if (slotResult != null && (item2 = slotResult.stack().m_41720_()) instanceof ECQuiverItem) {
            ECQuiverItem ecQuiverItem = (ECQuiverItem)item2;
            if (ecQuiverItem.providedSlots > this.slotContext.index()) {
                return super.m_7543_();
            }
        }
        return null;
    }

    public void m_5852_(@Nonnull ItemStack stack) {
        ItemStack current = this.m_7993_();
        boolean flag = current.m_41619_() && stack.m_41619_();
        super.m_5852_(stack);
        if (!(flag || ItemStack.m_41728_((ItemStack)current, (ItemStack)stack) || ((AccessorEntity)this.player).getFirstTick())) {
            CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onEquipFromUse(this.slotContext));
        }
    }

    public boolean m_5857_(@Nonnull ItemStack stack) {
        CurioEquipEvent equipEvent = new CurioEquipEvent(stack, this.slotContext);
        MinecraftForge.EVENT_BUS.post((Event)equipEvent);
        Event.Result result = equipEvent.getResult();
        if (result == Event.Result.DENY) {
            return false;
        }
        return result == Event.Result.ALLOW || CuriosApi.getCuriosHelper().isStackValid(this.slotContext, stack) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canEquip(this.slotContext)).orElse(true) != false && super.m_5857_(stack);
    }

    public boolean m_8010_(Player playerIn) {
        ItemStack stack = this.m_7993_();
        CurioUnequipEvent unequipEvent = new CurioUnequipEvent(stack, this.slotContext);
        MinecraftForge.EVENT_BUS.post((Event)unequipEvent);
        Event.Result result = unequipEvent.getResult();
        if (result == Event.Result.DENY) {
            return false;
        }
        return result == Event.Result.ALLOW || (stack.m_41619_() || playerIn.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)stack)) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canUnequip(this.slotContext)).orElse(true) != false && super.m_8010_(playerIn);
    }

    public boolean m_280329_() {
        int id;
        Item item;
        SlotResult slotResult = CuriosApi.getCuriosHelper().findCurio((LivingEntity)Objects.requireNonNull(Minecraft.m_91087_().f_91074_), "quiver_ec", 0).orElse(null);
        int curiosSlots = 0;
        if (slotResult != null && (item = slotResult.stack().m_41720_()) instanceof ECQuiverItem) {
            ECQuiverItem ecQuiverItem = (ECQuiverItem)item;
            curiosSlots = ecQuiverItem.providedSlots;
        }
        return curiosSlots > (id = this.slotContext.index());
    }
}

