/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.init;

import com.userofbricks.expanded_combat.ExpandedCombat;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.WeaponMaterial;
import com.userofbricks.expanded_combat.api.registry.IExpandedCombatPlugin;
import com.userofbricks.expanded_combat.api.registry.RegistrationHandler;
import com.userofbricks.expanded_combat.api.registry.ShieldMaterialUseTick;
import com.userofbricks.expanded_combat.api.registry.ShieldToMaterials;
import com.userofbricks.expanded_combat.plugins.VanillaECPlugin;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MaterialInit {
    public static List<Material> materials = new ArrayList<Material>();
    public static List<WeaponMaterial> weaponMaterialConfigs = new ArrayList<WeaponMaterial>();
    public static List<ShieldToMaterials> shieldToMaterialsList = new ArrayList<ShieldToMaterials>();
    public static List<ShieldMaterialUseTick> shieldMaterialUseTickList = new ArrayList<ShieldMaterialUseTick>();
    public static List<Material> gauntletMaterials = new ArrayList<Material>();
    public static List<Material> shieldMaterials = new ArrayList<Material>();
    public static List<Material> bowMaterials = new ArrayList<Material>();
    public static List<Material> crossbowMaterials = new ArrayList<Material>();
    public static List<Material> arrowMaterials = new ArrayList<Material>();
    public static List<Material> quiverMaterials = new ArrayList<Material>();
    public static List<Material> weaponMaterials = new ArrayList<Material>();

    public static void loadClass() {
        for (IExpandedCombatPlugin plugin : ExpandedCombat.PLUGINS) {
            plugin.registerMaterials(new RegistrationHandler());
            plugin.registerShieldToMaterials(new RegistrationHandler.ShieldMaterialRegisterator());
        }
    }

    public static Material getMaterialForShieldPart(String part, ItemLike shield) {
        for (ShieldToMaterials shieldToMaterials : shieldToMaterialsList) {
            if (shield.m_5456_() != shieldToMaterials.itemLikeSupplier().get().m_5456_()) continue;
            return switch (part) {
                case "dr" -> shieldToMaterials.dr();
                case "dl" -> shieldToMaterials.dl();
                case "ur" -> shieldToMaterials.ur();
                case "ul" -> shieldToMaterials.ul();
                default -> shieldToMaterials.m();
            };
        }
        return switch (part) {
            case "dr", "dl", "ur", "ul" -> VanillaECPlugin.SPRUCE_PLANK;
            case "m" -> VanillaECPlugin.IRON;
            default -> VanillaECPlugin.OAK_PLANK;
        };
    }

    public static boolean doesShieldHaveEntry(ItemLike shield) {
        for (ShieldToMaterials shieldToMaterials : shieldToMaterialsList) {
            if (shield.m_5456_() != shieldToMaterials.itemLikeSupplier().get().m_5456_()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ShieldMaterialUseTick getShieldHaveUseTickEntry(Material material) {
        for (ShieldMaterialUseTick shieldMaterialUseTick : shieldMaterialUseTickList) {
            if (material != shieldMaterialUseTick.material()) continue;
            return shieldMaterialUseTick;
        }
        return null;
    }

    public static Material valueOf(String name) {
        for (Material material : materials) {
            if (!material.getName().equals(name)) continue;
            return material;
        }
        return materials.get(0);
    }

    public static Material valueOfArrow(String name) {
        for (Material material : arrowMaterials) {
            if (!material.getName().equals(name)) continue;
            return material;
        }
        return VanillaECPlugin.IRON;
    }

    public static Material valueOfBow(String name) {
        for (Material material : bowMaterials) {
            if (!material.getName().equals(name)) continue;
            return material;
        }
        return VanillaECPlugin.IRON;
    }

    public static Material valueOfCrossBow(String name) {
        for (Material material : crossbowMaterials) {
            if (!material.getName().equals(name)) continue;
            return material;
        }
        return VanillaECPlugin.IRON;
    }

    public static Material valueOfGauntlet(String name) {
        for (Material material : gauntletMaterials) {
            if (!material.getName().equals(name)) continue;
            return material;
        }
        return VanillaECPlugin.LEATHER;
    }

    public static Material valueOfQuiver(String name) {
        for (Material material : quiverMaterials) {
            if (!material.getName().equals(name)) continue;
            return material;
        }
        return VanillaECPlugin.LEATHER;
    }

    public static Material valueOfShield(String part, String name) {
        for (Material material : shieldMaterials) {
            if (material.getName().equals(name)) {
                return material;
            }
            if (material.getAliases() == null || material.getAliases().isEmpty()) continue;
            ArrayList<String> pastNames = new ArrayList<String>();
            if (part.equals("any")) {
                for (List<String> names : material.getAliases().values()) {
                    pastNames.addAll(names);
                }
            } else if (material.getAliases().containsKey(part)) {
                pastNames.addAll((Collection)material.getAliases().get(part));
            }
            if (pastNames.isEmpty()) continue;
            for (String alias : pastNames) {
                if (!material.getName().equals(alias)) continue;
                return material;
            }
        }
        return VanillaECPlugin.OAK_PLANK;
    }

    public static Material valueOfShield(ItemStack itemStack) {
        for (Material material : shieldMaterials) {
            if (!(material.getConfig().crafting.craftingItem != null && !material.getConfig().crafting.craftingItem.isEmpty() ? ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.craftingItem)) == itemStack.m_41720_() : !material.getConfig().crafting.repairItem.isEmpty() && IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem).test(itemStack))) continue;
            return material;
        }
        return VanillaECPlugin.OAK_PLANK;
    }

    @Nullable
    public static WeaponMaterial valueOfWeapon(String name) {
        for (WeaponMaterial weaponMaterial : weaponMaterialConfigs) {
            if (!weaponMaterial.name().equals(name)) continue;
            return weaponMaterial;
        }
        return null;
    }
}

