/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.init;

import com.tterrag.registrate.Registrate;
import com.userofbricks.expanded_combat.ExpandedCombat;
import com.userofbricks.expanded_combat.config.ConfigName;
import com.userofbricks.expanded_combat.config.ECConfig;
import com.userofbricks.expanded_combat.config.TooltipFrase;
import com.userofbricks.expanded_combat.config.TooltipFrases;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class LangStrings {
    public static final String GOLD_MENDING_TOOLTIP = "tooltip.expanded_combat.mending_bonus";
    public static final String FLETCHING_TABLE_SCREEN_TITLE = "container.expanded_combat.fletching";
    public static final String UPPER_LEFT_MATERIAL = "tooltip.expanded_combat.shield_material.upper_left";
    public static final String UPPER_RIGHT_MATERIAL = "tooltip.expanded_combat.shield_material.upper_right";
    public static final String CENTER_MATERIAL = "tooltip.expanded_combat.shield_material.pegs_trim";
    public static final String LOWER_LEFT_MATERIAL = "tooltip.expanded_combat.shield_material.lower_left";
    public static final String LOWER_RIGHT_MATERIAL = "tooltip.expanded_combat.shield_material.lower_right";
    public static final String SHIELD_MATERIAL_LANG_START = "tooltip.expanded_combat.shield_material.";
    public static final String SHIELD_UPGRADE_CONTAINER = "container.upgrade_shield";
    public static final String TIPPED_ARROW_POTION_ENDING = "arrow.expanded_combat.effect.";
    public static final String CYCLE_QUIVER_RIGHT = "key.expanded_combat.cycle_quiver_right";
    public static final String CYCLE_QUIVER_LEFT = "key.expanded_combat.cycle_quiver_left";
    public static final String KEY_CATEGORY = "key.expanded_combat.category";
    public static final String CONSUMES_CURSES_LANG = "tooltip.expanded_combat.consumes_curses";
    public static final String EDIBLE = "tooltip.expanded_combat.edible";
    public static final String FOUND_AT_HEIGHT_LIMIT = "tooltip.expanded_combat.found_at_height_limit";
    private static final Supplier<String> configLangStartGetter = () -> "text.autoconfig." + ECConfig.class.getAnnotation(Config.class).name();
    private static final BiFunction<String, String, String> categoryFunction = (baseI13n, categoryName) -> String.format("%s.category.%s", baseI13n, categoryName);
    private static final BiFunction<String, Field, String> optionFunction = (baseI13n, field) -> String.format("%s.option.%s", baseI13n, field.getName());
    private static final List<Pair<String, String>> autoGeneratePairList = new ArrayList<Pair<String, String>>();

    public static void registerLang() {
        LangStrings.createAttributeDescriptionLang("dmg_no_weapon", "Added Weaponless Damage");
        LangStrings.createAttributeDescriptionLang("heat_dmg", "Heat Damage");
        LangStrings.createAttributeDescriptionLang("cold_dmg", "Cold Damage");
        LangStrings.createAttributeDescriptionLang("void_dmg", "Void Damage");
        for (Pair<String, String> pair : autoGeneratePairList) {
            ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang((String)pair.getLeft(), (String)pair.getRight());
        }
        ArrayList<String> alreadyAddedStrings = new ArrayList<String>();
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(UPPER_RIGHT_MATERIAL, "Upper Right: ");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(UPPER_LEFT_MATERIAL, "Upper Left: ");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(CENTER_MATERIAL, "Pegs & Trim: ");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(LOWER_RIGHT_MATERIAL, "Lower Right: ");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(LOWER_LEFT_MATERIAL, "Lower Left: ");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(SHIELD_UPGRADE_CONTAINER, "Upgrade Shield");
        for (Potion potion : ForgeRegistries.POTIONS) {
            LangStrings.getOrCreateLang((Registrate)ExpandedCombat.REGISTRATE.get(), alreadyAddedStrings, potion.m_43492_(TIPPED_ARROW_POTION_ENDING), " of " + LangStrings.locationToName(potion.m_43492_("")), "");
        }
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(KEY_CATEGORY, "Expanded Combat");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(CYCLE_QUIVER_LEFT, "Cycle Quiver Left");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(CYCLE_QUIVER_RIGHT, "Cycle Quiver Right");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang("curios.identifier.quiver_ec", "Quiver");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang("curios.identifier.arrows", "Arrow");
        String string = configLangStartGetter.get();
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(string + ".title", "Expanded Combat Settings");
        Arrays.stream(ECConfig.class.getDeclaredFields()).collect(Collectors.groupingBy(field -> LangStrings.getOrCreateCategoryForField((Registrate)ExpandedCombat.REGISTRATE.get(), field, alreadyAddedStrings, string), LinkedHashMap::new, Collectors.toList())).forEach((key, value) -> value.forEach(field -> LangStrings.ifNotExcludedRegisterLangs((Registrate)ExpandedCombat.REGISTRATE.get(), field, configLangStart, alreadyAddedStrings)));
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(GOLD_MENDING_TOOLTIP, "Mending Bonus");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(FLETCHING_TABLE_SCREEN_TITLE, "Fletching Table");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(CONSUMES_CURSES_LANG, "Consumes Curses");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(EDIBLE, "Smells Delectable");
        ((Registrate)ExpandedCombat.REGISTRATE.get()).addRawLang(FOUND_AT_HEIGHT_LIMIT, "Block can be found at world height limit");
    }

    public static String getOrCreateCategoryForField(Registrate registrate, Field field, List<String> alreadyAddedStrings, String configLangStart) {
        String categoryName = "Default";
        if (field.isAnnotationPresent(ConfigEntry.Category.class)) {
            categoryName = field.getAnnotation(ConfigEntry.Category.class).value();
            String categoryLang = categoryFunction.apply(configLangStart, categoryName);
            LangStrings.getOrCreateLang(registrate, alreadyAddedStrings, categoryLang, categoryName, " Settings");
        }
        return categoryName;
    }

    public static void getOrCreateLang(Registrate registrate, List<String> alreadyAddedStrings, String lang, String Name, String sufix) {
        if (!alreadyAddedStrings.contains(lang)) {
            alreadyAddedStrings.add(lang);
            registrate.addRawLang(lang, Name + sufix);
        }
    }

    public static void ifNotExcludedRegisterLangs(Registrate registrate, Field field, String configLangStart, List<String> alreadyAddedStrings) {
        if (!field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class)) {
            Object optionLang = configLangStart.contains("option") ? configLangStart + "." + field.getName() : optionFunction.apply(configLangStart, field);
            LangStrings.getOrCreateLang(registrate, alreadyAddedStrings, (String)optionLang, LangStrings.getConfigOptionName(field), "");
            if (field.isAnnotationPresent(ConfigEntry.Gui.Tooltip.class) && (field.isAnnotationPresent(TooltipFrase.class) || field.isAnnotationPresent(TooltipFrases.class))) {
                int tooltipLines = field.getAnnotation(ConfigEntry.Gui.Tooltip.class).count();
                HashMap<Integer, String> tooltips = new HashMap<Integer, String>();
                for (TooltipFrase tooltip : (TooltipFrase[])field.getAnnotationsByType(TooltipFrase.class)) {
                    tooltips.put(tooltip.line(), tooltip.value());
                }
                if (tooltipLines == 1) {
                    LangStrings.getOrCreateLang(registrate, alreadyAddedStrings, (String)optionLang + ".@Tooltip", (String)tooltips.get(0), "");
                } else {
                    for (int tooltipLine = 0; tooltipLine < tooltipLines; ++tooltipLine) {
                        String tooltip = (String)tooltips.get(tooltipLine);
                        LangStrings.getOrCreateLang(registrate, alreadyAddedStrings, (String)optionLang + ".@Tooltip[" + tooltipLine + "]", (String)(tooltip == null ? "Needs TooltipFrase Annotation defined for Tooltip[" + tooltipLine + "]" : tooltip), "");
                    }
                }
            }
            if (field.isAnnotationPresent(ConfigEntry.Gui.CollapsibleObject.class) || field.isAnnotationPresent(ConfigEntry.Gui.TransitiveObject.class)) {
                for (Field fieldOfField : field.getType().getDeclaredFields()) {
                    LangStrings.ifNotExcludedRegisterLangs(registrate, fieldOfField, (String)optionLang, alreadyAddedStrings);
                }
            }
        }
    }

    private static String getConfigOptionName(Field field) {
        if (field.isAnnotationPresent(ConfigName.class)) {
            return field.getAnnotation(ConfigName.class).value();
        }
        return field.getName();
    }

    public static String locationToName(String location) {
        List<String> parts = Arrays.stream(location.split("_")).map(part -> {
            String firstLetter = String.valueOf(part.charAt(0)).toUpperCase(Locale.ROOT);
            String theRest = part.substring(1);
            return firstLetter + theRest;
        }).toList();
        return String.join((CharSequence)" ", parts);
    }

    public static String createAdvancementLang(String advancementName, final String englishLang, boolean tittle) {
        final String lang = "advancements.expanded_combat." + advancementName + "." + (tittle ? "title" : "description");
        autoGeneratePairList.add(new Pair<String, String>(){

            public String getLeft() {
                return lang;
            }

            public String getRight() {
                return englishLang;
            }

            public String setValue(String value) {
                return null;
            }
        });
        return lang;
    }

    public static String createCommandLang(String command, boolean pass, String identifier, final String englishLang) {
        final String lang = "commands." + command + "." + (pass ? "success" : "failed") + "." + identifier;
        autoGeneratePairList.add(new Pair<String, String>(){

            public String getLeft() {
                return lang;
            }

            public String getRight() {
                return englishLang;
            }

            public String setValue(String value) {
                return null;
            }
        });
        return lang;
    }

    public static String createAttributeDescriptionLang(String command, final String englishLang) {
        final String lang = "attribute.expanded_combat." + command + ".desc";
        autoGeneratePairList.add(new Pair<String, String>(){

            public String getLeft() {
                return lang;
            }

            public String getRight() {
                return englishLang;
            }

            public String setValue(String value) {
                return null;
            }
        });
        return lang;
    }

    public static String getLocationPathVersion(String string) {
        return string.toLowerCase(Locale.ROOT).replace(' ', '_').replace("'", "_");
    }
}

