/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.init;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.userofbricks.expanded_combat.ExpandedCombat;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.init.ECItems;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.item.ECShieldItem;
import com.userofbricks.expanded_combat.plugins.VanillaECPlugin;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="expanded_combat", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECCreativeTabs {
    public static final RegistryEntry<CreativeModeTab> EC_GROUP = ((Registrate)ExpandedCombat.REGISTRATE.get()).defaultCreativeTab("expanded_combat", builder -> builder.m_257737_(() -> new ItemStack((ItemLike)ECCreativeTabs.getIcon())).m_257501_((displayParameters, output) -> {
        output.m_246326_((ItemLike)ECItems.LEATHER_STICK.get());
        output.m_246326_((ItemLike)ECItems.GOLD_STICK.get());
        output.m_246326_((ItemLike)ECItems.IRON_STICK.get());
        output.m_246326_((ItemLike)ECItems.GAS_BOTTLE.get());
        output.m_246326_((ItemLike)ECItems.PURIFIED_GAS_BOTTLE.get());
        output.m_246326_((ItemLike)ECItems.SOLIDIFIED_PURIFICATION.get());
        output.m_246326_((ItemLike)ECItems.ALLAY_ITEM.get());
        if (ExpandedCombat.CONFIG.enableGauntlets) {
            for (Material material : MaterialInit.gauntletMaterials) {
                output.m_246326_((ItemLike)material.getGauntletEntry().get());
            }
        }
        if (ExpandedCombat.CONFIG.enableShields) {
            for (Material material : MaterialInit.shieldMaterials) {
                ItemStack stack = !material.getConfig().fireResistant ? ((ECShieldItem)((Object)((Object)((Object)ECItems.SHIELD_TIER_1.get())))).m_7968_() : ((ECShieldItem)((Object)((Object)((Object)ECItems.SHIELD_TIER_3.get())))).m_7968_();
                stack.m_41784_().m_128359_("UL_Material", material.getName());
                stack.m_41784_().m_128359_("UR_Material", material.getName());
                stack.m_41784_().m_128359_("DL_Material", material.getName());
                stack.m_41784_().m_128359_("DR_Material", material.getName());
                if (material.shieldUse == Material.ShieldUse.ALL) {
                    stack.m_41784_().m_128359_("M_Material", material.getName());
                } else {
                    stack.m_41784_().m_128359_("M_Material", VanillaECPlugin.IRON.getName());
                }
                output.m_246342_(stack);
            }
        }
        if (ExpandedCombat.CONFIG.enableBows) {
            for (Material material : MaterialInit.bowMaterials) {
                if (material.halfbow && !ExpandedCombat.CONFIG.enableHalfBows) continue;
                output.m_246326_((ItemLike)material.getBowEntry().get());
            }
        }
        if (ExpandedCombat.CONFIG.enableCrossbows) {
            for (Material material : MaterialInit.crossbowMaterials) {
                output.m_246326_((ItemLike)material.getCrossbowEntry().get());
            }
        }
        if (ExpandedCombat.CONFIG.enableQuivers) {
            for (Material material : MaterialInit.quiverMaterials) {
                output.m_246326_((ItemLike)material.getQuiverEntry().get());
            }
        }
        if (ExpandedCombat.CONFIG.enableArrows) {
            for (Material material : MaterialInit.arrowMaterials) {
                output.m_246326_((ItemLike)material.getArrowEntry().get());
            }
            for (Potion potion : ForgeRegistries.POTIONS) {
                for (Material material : MaterialInit.arrowMaterials) {
                    if (potion.m_43488_().isEmpty()) continue;
                    output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)material.getTippedArrowEntry().get()), (Potion)potion));
                }
            }
        }
        if (ExpandedCombat.CONFIG.enableWeapons) {
            for (Material material : MaterialInit.weaponMaterials) {
                for (RegistryEntry registryEntry : material.getWeapons().values()) {
                    output.m_246342_(((Item)registryEntry.get()).m_7968_());
                }
            }
        }
    }).m_257652_()).register();

    private static Item getIcon() {
        if (ExpandedCombat.CONFIG.enableGauntlets) {
            return (Item)VanillaECPlugin.DIAMOND.getGauntletEntry().get();
        }
        return Items.f_42412_;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void ModifyVanillaCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tab = event.getTabKey();
        if (tab == CreativeModeTabs.f_256797_) {
            MutableHashedLinkedMap items = event.getEntries();
            if (ExpandedCombat.CONFIG.enableGauntlets) {
                for (Material material : MaterialInit.gauntletMaterials) {
                    if (material == VanillaECPlugin.LEATHER) {
                        items.putBefore((Object)new ItemStack((ItemLike)Items.f_42407_), (Object)new ItemStack((ItemLike)material.getGauntletEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        continue;
                    }
                    if (material == VanillaECPlugin.IRON) {
                        items.putBefore((Object)new ItemStack((ItemLike)Items.f_42468_), (Object)new ItemStack((ItemLike)material.getGauntletEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        continue;
                    }
                    if (material == VanillaECPlugin.GOLD) {
                        items.putBefore((Object)new ItemStack((ItemLike)Items.f_42476_), (Object)new ItemStack((ItemLike)material.getGauntletEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        continue;
                    }
                    if (material == VanillaECPlugin.DIAMOND) {
                        items.putBefore((Object)new ItemStack((ItemLike)Items.f_42472_), (Object)new ItemStack((ItemLike)material.getGauntletEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        continue;
                    }
                    if (material == VanillaECPlugin.NETHERITE) {
                        items.putBefore((Object)new ItemStack((ItemLike)Items.f_42480_), (Object)new ItemStack((ItemLike)material.getGauntletEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        continue;
                    }
                    items.putAfter((Object)new ItemStack((ItemLike)Items.f_42354_), (Object)new ItemStack((ItemLike)material.getGauntletEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
            if (ExpandedCombat.CONFIG.enableShields) {
                for (int shieldListLocation = MaterialInit.shieldMaterials.size() - 1; shieldListLocation > -1; --shieldListLocation) {
                    Material material;
                    material = MaterialInit.shieldMaterials.get(shieldListLocation);
                    ItemStack stack = !material.getConfig().fireResistant ? ((ECShieldItem)((Object)ECItems.SHIELD_TIER_1.get())).m_7968_() : ((ECShieldItem)((Object)ECItems.SHIELD_TIER_3.get())).m_7968_();
                    stack.m_41784_().m_128359_("UL_Material", material.getName());
                    stack.m_41784_().m_128359_("UR_Material", material.getName());
                    stack.m_41784_().m_128359_("DL_Material", material.getName());
                    stack.m_41784_().m_128359_("DR_Material", material.getName());
                    if (material.shieldUse == Material.ShieldUse.ALL) {
                        stack.m_41784_().m_128359_("M_Material", material.getName());
                    } else {
                        stack.m_41784_().m_128359_("M_Material", VanillaECPlugin.IRON.getName());
                    }
                    items.putAfter((Object)new ItemStack((ItemLike)Items.f_42740_), (Object)stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
            if (ExpandedCombat.CONFIG.enableBows) {
                for (Material material : MaterialInit.bowMaterials) {
                    if (material.halfbow && !ExpandedCombat.CONFIG.enableHalfBows) continue;
                    items.putAfter((Object)new ItemStack((ItemLike)Items.f_42411_), (Object)new ItemStack((ItemLike)material.getBowEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
            if (ExpandedCombat.CONFIG.enableCrossbows) {
                for (Material material : MaterialInit.crossbowMaterials) {
                    items.putAfter((Object)new ItemStack((ItemLike)Items.f_42717_), (Object)new ItemStack((ItemLike)material.getCrossbowEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
            if (ExpandedCombat.CONFIG.enableQuivers) {
                for (Material material : MaterialInit.quiverMaterials) {
                    items.putBefore((Object)new ItemStack((ItemLike)Items.f_42412_), (Object)new ItemStack((ItemLike)material.getQuiverEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
            if (ExpandedCombat.CONFIG.enableArrows) {
                for (Material material : MaterialInit.arrowMaterials) {
                    items.putAfter((Object)new ItemStack((ItemLike)Items.f_42412_), (Object)new ItemStack((ItemLike)material.getArrowEntry().get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
                for (Potion potion : ForgeRegistries.POTIONS) {
                    for (Material material : MaterialInit.arrowMaterials) {
                        if (potion.m_43488_().isEmpty()) continue;
                        items.putAfter((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)potion), (Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)material.getTippedArrowEntry().get()), (Potion)potion), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    }
                }
            }
            if (ExpandedCombat.CONFIG.enableWeapons) {
                for (Material material : MaterialInit.weaponMaterials) {
                    for (RegistryEntry registryEntry : material.getWeapons().values()) {
                        items.put((Object)((Item)registryEntry.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    }
                }
            }
        } else if (tab == CreativeModeTabs.f_256968_) {
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42398_), (Object)new ItemStack((ItemLike)ECItems.LEATHER_STICK.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ECItems.LEATHER_STICK.get()), (Object)new ItemStack((ItemLike)ECItems.GOLD_STICK.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ECItems.GOLD_STICK.get()), (Object)new ItemStack((ItemLike)ECItems.IRON_STICK.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42612_), (Object)new ItemStack((ItemLike)ECItems.ALLAY_ITEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42612_), (Object)new ItemStack((ItemLike)ECItems.BAD_SOUL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42612_), (Object)new ItemStack((ItemLike)ECItems.GOOD_SOUL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42612_), (Object)new ItemStack((ItemLike)ECItems.SOLIDIFIED_PURIFICATION.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42612_), (Object)new ItemStack((ItemLike)ECItems.PURIFIED_GAS_BOTTLE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42612_), (Object)new ItemStack((ItemLike)ECItems.GAS_BOTTLE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static void loadClass() {
    }
}

