/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.events;

import com.userofbricks.expanded_combat.ExpandedCombat;
import com.userofbricks.expanded_combat.client.renderer.gui.screen.inventory.ShieldSmithingTableScreen;
import com.userofbricks.expanded_combat.client.renderer.gui.screen.inventory.ShieldTabButtion;
import com.userofbricks.expanded_combat.init.ECEnchantments;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.item.ECKatanaItem;
import com.userofbricks.expanded_combat.item.ECShieldItem;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ShieldEvents {
    @SubscribeEvent
    public static void ShieldBlockingEvent(ShieldBlockEvent event) {
        if (!ExpandedCombat.CONFIG.shieldProtectionConfig.EnableVanillaStyleShieldProtection && !(event.getEntity().m_21211_().m_41720_() instanceof ECKatanaItem)) {
            ItemStack shieldItemStack = event.getEntity().m_21211_();
            float damageBlocked = 0.0f;
            float damageLeftToBlock = event.getOriginalBlockedDamage();
            if (ExpandedCombat.CONFIG.shieldProtectionConfig.EnableShieldBaseProtection) {
                damageBlocked += ShieldEvents.BaseShieldProtection(shieldItemStack, damageLeftToBlock);
                damageLeftToBlock -= damageBlocked;
            }
            if (ExpandedCombat.CONFIG.shieldProtectionConfig.EnableShieldProtectionPercentage) {
                double damagePercent = ExpandedCombat.CONFIG.vanilla.defense.afterBasePercentReduction;
                if (shieldItemStack.m_41720_() instanceof ECShieldItem) {
                    damagePercent = ECShieldItem.getPercentageProtection(shieldItemStack);
                } else if (MaterialInit.doesShieldHaveEntry((ItemLike)shieldItemStack.m_41720_())) {
                    damagePercent = ECShieldItem.getShieldToMaterialPercentageProtection(shieldItemStack);
                }
                damageBlocked += (float)((double)damageLeftToBlock * damagePercent);
            }
            event.setBlockedDamage(damageBlocked);
        }
    }

    private static float BaseShieldProtection(ItemStack shieldItemStack, float damageLeftToBlock) {
        float damageBlocked = 0.0f;
        switch (ExpandedCombat.CONFIG.shieldProtectionConfig.shieldBaseProtectionType) {
            case PREDEFINED_AMMOUNT: {
                double protectionAmount = ExpandedCombat.CONFIG.vanilla.defense.baseProtectionAmmount;
                if (shieldItemStack.m_41720_() instanceof ECShieldItem) {
                    protectionAmount = ECShieldItem.getBaseProtection(shieldItemStack);
                } else if (MaterialInit.doesShieldHaveEntry((ItemLike)shieldItemStack.m_41720_())) {
                    protectionAmount = ECShieldItem.getShieldToMaterialBaseProtection(shieldItemStack);
                }
                damageBlocked = (float)protectionAmount + (float)shieldItemStack.getEnchantmentLevel((Enchantment)ECEnchantments.BLOCKING.get());
                break;
            }
            case DURABILITY_PERCENTAGE: {
                if (shieldItemStack.m_41776_() == 0) {
                    damageBlocked = damageLeftToBlock;
                    break;
                }
                float itemDamageLeft = Math.min((float)shieldItemStack.m_41776_(), (float)shieldItemStack.m_41776_() - (float)shieldItemStack.m_41773_() + (float)shieldItemStack.m_41776_() * ((float)shieldItemStack.getEnchantmentLevel((Enchantment)ECEnchantments.BLOCKING.get()) / 10.0f));
                damageBlocked = damageLeftToBlock * (itemDamageLeft / (float)shieldItemStack.m_41776_());
                break;
            }
            case INVERTED_DURABILITY_PERCENTAGE: {
                if (shieldItemStack.m_41776_() == 0) break;
                damageBlocked += damageLeftToBlock * (((float)shieldItemStack.m_41773_() + (float)shieldItemStack.m_41776_() * ((float)shieldItemStack.getEnchantmentLevel((Enchantment)ECEnchantments.BLOCKING.get()) / 10.0f)) / (float)shieldItemStack.m_41776_());
            }
        }
        return damageBlocked;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onInventoryGuiInit(ScreenEvent.Init.Post evt) {
        Screen screen = evt.getScreen();
        if (screen instanceof SmithingScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            int sizeX = 20;
            int sizeY = 20;
            int textureOffsetX = 224;
            int textureOffsetY = 0;
            int yOffset = 36;
            int xOffset = -21;
            evt.addListener((GuiEventListener)new ShieldTabButtion(gui, gui.getGuiLeft() + xOffset, gui.getGuiTop() + yOffset, sizeX, sizeY, textureOffsetX, textureOffsetY, 0, ShieldSmithingTableScreen.SHIELD_SMITHING_LOCATION));
        } else if (screen instanceof ShieldSmithingTableScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            int sizeX = 20;
            int sizeY = 20;
            int textureOffsetX = 204;
            int textureOffsetY = 0;
            int yOffset = 8;
            int xOffset = -21;
            evt.addListener((GuiEventListener)new ShieldTabButtion(gui, gui.getGuiLeft() + xOffset, gui.getGuiTop() + yOffset, sizeX, sizeY, textureOffsetX, textureOffsetY, 0, ShieldSmithingTableScreen.SHIELD_SMITHING_LOCATION));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void drawTabs(ContainerScreenEvent.Render.Background e) {
        if (e.getContainerScreen() instanceof SmithingScreen) {
            AbstractContainerScreen smithingTableScreen = e.getContainerScreen();
            int left = smithingTableScreen.getGuiLeft();
            int top = smithingTableScreen.getGuiTop();
            e.getGuiGraphics().m_280218_(ShieldSmithingTableScreen.SHIELD_SMITHING_LOCATION, left - 28, top + 4, 0, 194, 32, 28);
            e.getGuiGraphics().m_280218_(ShieldSmithingTableScreen.SHIELD_SMITHING_LOCATION, left - 28, top + 32, 0, 166, 32, 28);
            e.getGuiGraphics().m_280218_(ShieldSmithingTableScreen.SHIELD_SMITHING_LOCATION, left - 23, top + 8, 204, 0, 20, 20);
        } else {
            AbstractContainerScreen smithingTableScreen = e.getContainerScreen();
            if (smithingTableScreen instanceof ShieldSmithingTableScreen) {
                ShieldSmithingTableScreen smithingTableScreen2 = (ShieldSmithingTableScreen)smithingTableScreen;
                int left = smithingTableScreen2.getGuiLeft();
                int top = smithingTableScreen2.getGuiTop();
                e.getGuiGraphics().m_280218_(ShieldSmithingTableScreen.SHIELD_SMITHING_LOCATION, left - 28, top + 4, 0, 166, 32, 56);
                e.getGuiGraphics().m_280218_(ShieldSmithingTableScreen.SHIELD_SMITHING_LOCATION, left - 23, top + 36, 224, 0, 20, 20);
            }
        }
    }
}

