/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.events;

import com.userofbricks.expanded_combat.item.ECQuiverItem;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.client.gui.CuriosScreenV2;
import top.theillusivec4.curios.common.inventory.container.CuriosContainerV2;

public class QuiverEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onArrowItemPickup(EntityItemPickupEvent evt) {
        Item item2;
        Player player = evt.getEntity();
        ItemStack toPickup = evt.getItem().m_32055_();
        SlotResult slotResult = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, item -> item.m_41720_() instanceof ECQuiverItem).orElse(null);
        if (toPickup.m_204117_(ItemTags.f_13161_) && slotResult != null && (item2 = slotResult.stack().m_41720_()) instanceof ECQuiverItem) {
            ECQuiverItem quiverItem = (ECQuiverItem)item2;
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(curios -> {
                IDynamicStackHandler arrowStackHandler = ((ICurioStacksHandler)curios.getCurios().get("arrows")).getStacks();
                int slots = arrowStackHandler.getSlots();
                for (int s = 0; s < slots; ++s) {
                    ItemStack currentStack = arrowStackHandler.getStackInSlot(s);
                    ItemStack rem = toPickup.m_41777_();
                    int itemsRemaining = toPickup.m_41613_();
                    if ((currentStack.m_41720_() == toPickup.m_41720_() || currentStack.m_41619_()) && quiverItem.providedSlots > s && (rem = arrowStackHandler.insertItem(s, rem, false)).m_41613_() < itemsRemaining) {
                        player.m_6278_(Stats.f_12984_.m_12902_((Object)toPickup.m_41720_()), itemsRemaining - rem.m_41613_());
                    }
                    toPickup.m_41764_(rem.m_41613_());
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onInventoryGuiInit(ContainerScreenEvent.Render.Background evt) {
        AbstractContainerScreen screen = evt.getContainerScreen();
        if (screen instanceof CuriosScreenV2) {
            CuriosScreenV2 curiosScreen = (CuriosScreenV2)screen;
            ResourceLocation textureLocation = new ResourceLocation("expanded_combat", "textures/gui/container/quiver.png");
            int left = curiosScreen.getGuiLeft();
            int top = curiosScreen.getGuiTop();
            evt.getGuiGraphics().m_280218_(textureLocation, left + 76, top + 43, 45, 18, 18, 18);
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)((CuriosContainerV2)curiosScreen.m_6262_()).player).ifPresent(curios -> {
                Item quiverItem = ((ICurioStacksHandler)curios.getCurios().get("quiver_ec")).getStacks().getStackInSlot(0).m_41720_();
                int curiosSlots = 0;
                if (quiverItem instanceof ECQuiverItem) {
                    ECQuiverItem ecQuiverItem = (ECQuiverItem)quiverItem;
                    curiosSlots = ecQuiverItem.providedSlots;
                }
                if (curiosSlots > 0) {
                    evt.getGuiGraphics().m_280218_(textureLocation, left + 175, top + 4, 0, 0, 2, 158);
                    for (int column = 0; column < QuiverEvents.roundToNearest8(curiosSlots) / 8; ++column) {
                        if (column - QuiverEvents.roundToNearest8(curiosSlots) / 8 == -1) {
                            evt.getGuiGraphics().m_280218_(textureLocation, left + 177 + column * 18, top + 4, 20, 0, 25, 158);
                            continue;
                        }
                        evt.getGuiGraphics().m_280218_(textureLocation, left + 177 + column * 18, top + 4, 2, 0, 18, 158);
                    }
                    int x = 177;
                    int y = 11;
                    int row = 1;
                    int slot = 0;
                    while (slot < QuiverEvents.roundToNearest8(curiosSlots)) {
                        if (slot >= curiosSlots) {
                            evt.getGuiGraphics().m_280218_(textureLocation, left + x, top + y, 45, 0, 18, 18);
                        }
                        y += 18;
                        if (row == 8) {
                            row = 0;
                            y = 11;
                            x += 18;
                        }
                        ++slot;
                        ++row;
                    }
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void moveEffectRenderingStack(ScreenEvent.RenderInventoryMobEffects event) {
        Screen screen = event.getScreen();
        if (screen instanceof CuriosScreenV2) {
            CuriosScreenV2 curiosScreen = (CuriosScreenV2)screen;
            ICuriosItemHandler curios = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)((CuriosContainerV2)curiosScreen.m_6262_()).player).resolve().orElse(null);
            if (curios != null) {
                Item quiverItem = ((ICurioStacksHandler)curios.getCurios().get("quiver_ec")).getStacks().getStackInSlot(0).m_41720_();
                int curiosSlots = 0;
                if (quiverItem instanceof ECQuiverItem) {
                    ECQuiverItem ecQuiverItem = (ECQuiverItem)quiverItem;
                    curiosSlots = ecQuiverItem.providedSlots;
                }
                if (curiosSlots > 0) {
                    int columns = QuiverEvents.roundToNearest8(curiosSlots) / 8;
                    int shift = columns * 18 + 8;
                    event.addHorizontalOffset(shift);
                }
            }
        }
    }

    public static int roundToNearest8(int original) {
        int modulus = original % 8;
        if (modulus != 0) {
            return original + (8 - modulus);
        }
        return original;
    }
}

