/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.events;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.userofbricks.expanded_combat.item.HeartStealerItem;
import com.userofbricks.expanded_combat.network.ECVariables;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="expanded_combat")
public class HeartsealerEvents {
    @SubscribeEvent
    public static void playerHearts(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.START) {
            float stolenHearts = (float)ECVariables.getStolenHealth((Entity)player) / 2.0f;
            int time = Math.round(player.m_9236_().m_46468_() % 24000L);
            if (!player.m_150109_().m_216874_(stack -> stack.m_41720_() instanceof HeartStealerItem) && !player.m_150109_().m_216874_(stack -> stack == ECVariables.getTheirHeartStealer((Entity)player)) && (stolenHearts >= 50.0f && time % 100 == 0 || stolenHearts >= 25.0f && time % 200 == 0 || stolenHearts >= 5.0f && time % 400 == 0)) {
                ECVariables.changeStolenHealth((LivingEntity)player, -1);
                player.m_6469_(player.m_269291_().m_269425_(), 1.0f);
            }
            if (player.m_9236_().m_45527_(player.m_20183_()) && !player.m_9236_().m_46462_() && (stolenHearts >= 80.0f && time % 20 == 0 || stolenHearts >= 60.0f && time % 40 == 0 || stolenHearts >= 40.0f && time % 80 == 0 || stolenHearts >= 20.0f && time % 160 == 0)) {
                player.m_6469_(player.m_269291_().m_269549_(), 1.0f);
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            player.m_21204_().m_22178_(HeartsealerEvents.getDefaultAttributeModifiers(player));
        }
    }

    @NotNull
    public static Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(@NotNull Player player) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("803f1818-3e4f-4605-8b1a-04d0c1c9f97d"), "Heartstealer Stolen modifier", (double)ECVariables.getStolenHealth((Entity)player), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("f7d9fc3d-4517-4e35-bcf3-12ce2d0a2457"), "Heartstealer Added modifier", (double)ECVariables.getAddedHealth((Entity)player), AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderPlayerStolenHearts(RenderPlayerEvent.Post event) {
        ClientLevel level = (ClientLevel)event.getEntity().m_9236_();
        Vec3 location = event.getEntity().m_20182_();
        RandomSource random = level.f_46441_;
        for (int i = 0; i < ECVariables.getStolenHealth((Entity)event.getEntity()) / 2; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123757_, location.f_82479_ + random.m_188500_(), location.f_82480_ + random.m_188500_() * 2.0, location.f_82481_ + random.m_188500_(), 0.0, 0.0, 0.0);
        }
    }
}

