/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.events;

import com.userofbricks.expanded_combat.item.ECItemTags;
import com.userofbricks.expanded_combat.item.ISimpleMaterialItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

@Mod.EventBusSubscriber(modid="expanded_combat", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GoldMending {
    @SubscribeEvent
    public void MendingBonus(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = player.m_6844_(slot);
            if (stack.m_41619_() && stack.getEnchantmentLevel(Enchantments.f_44962_) <= 0 && !stack.m_41768_() && !GoldMending.doesGoldMendingContainItem(stack)) continue;
            event.setCanceled(true);
            ExperienceOrb orb = event.getOrb();
            player.f_36101_ = 2;
            player.m_7938_((Entity)orb, 1);
            int toRepair = Math.min(orb.f_20770_ * 4, stack.m_41773_());
            orb.f_20770_ -= toRepair / 4;
            stack.m_41721_(stack.m_41773_() - toRepair);
            if (orb.f_20770_ > 0) {
                player.m_6756_(orb.f_20770_);
            }
            orb.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleToolTip(ItemTooltipEvent event) {
        ISimpleMaterialItem simpleMaterialItem;
        Item item;
        ItemStack itemStack = event.getItemStack();
        List list = event.getToolTip();
        if (GoldMending.doesGoldMendingContainItem(itemStack)) {
            list.add(1, Component.m_237115_((String)"tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)(ChatFormatting.BLUE + " +" + ItemStack.f_41584_.format(2L)))));
        }
        if ((item = itemStack.m_41720_()) instanceof ISimpleMaterialItem && (simpleMaterialItem = (ISimpleMaterialItem)item).getMendingBonus() != 0.0f) {
            if (simpleMaterialItem.getMendingBonus() > 0.0f) {
                list.add(1, Component.m_237115_((String)"tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)(ChatFormatting.BLUE + " +" + ItemStack.f_41584_.format(simpleMaterialItem.getMendingBonus())))));
            } else if (simpleMaterialItem.getMendingBonus() < 0.0f) {
                list.add(1, Component.m_237115_((String)"tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)(ChatFormatting.RED + " " + ItemStack.f_41584_.format(simpleMaterialItem.getMendingBonus())))));
            }
        }
    }

    public static boolean doesGoldMendingContainItem(ItemStack itemStack) {
        return GoldMending.doesGoldMendingContainItem(itemStack.m_41720_());
    }

    public static boolean doesGoldMendingContainItem(Item item) {
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        assert (tagManager != null);
        return tagManager.getTag(ECItemTags.NON_EC_MENDABLE_GOLD).contains((Object)item);
    }
}

