/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.events;

import com.google.common.collect.Multimap;
import com.userofbricks.expanded_combat.init.ECAttributes;
import com.userofbricks.expanded_combat.init.ECDamageInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="expanded_combat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.DEDICATED_SERVER})
public class GeneralForgeEventBusEvents {
    private static List<Runnable> ADDITIONAL_DMG_RUNS = new ArrayList<Runnable>();

    @SubscribeEvent
    public static void dealExtraDmg(LivingEvent.LivingTickEvent event) {
        ADDITIONAL_DMG_RUNS.forEach(Runnable::run);
        ADDITIONAL_DMG_RUNS.clear();
    }

    @SubscribeEvent
    public static void moreDamageSources(LivingHurtEvent ev) {
        Level level = ev.getEntity().m_9236_();
        Entity entity = ev.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity causingEntity = (LivingEntity)entity;
        Entity directEntity = ev.getSource().m_7640_();
        if (entity != directEntity) {
            return;
        }
        double gauntletDmg = causingEntity.m_21133_((Attribute)ECAttributes.GAUNTLET_DMG_WITHOUT_WEAPON.get());
        double coldDmg = causingEntity.m_21133_((Attribute)ECAttributes.COLD_DMG.get());
        double heatDmg = causingEntity.m_21133_((Attribute)ECAttributes.HEAT_DMG.get());
        double voidDmg = causingEntity.m_21133_((Attribute)ECAttributes.VOID_DMG.get());
        double soulDmg = causingEntity.m_21133_((Attribute)ECAttributes.SOUL_DMG.get());
        if (coldDmg > 0.0 && !ev.getSource().m_269533_(DamageTypeTags.f_273918_)) {
            ADDITIONAL_DMG_RUNS.add(() -> ev.getEntity().m_6469_(ECDamageInit.coldDmgAttack(level, entity), (float)coldDmg));
        }
        if (heatDmg > 0.0 && !ev.getSource().m_269533_(DamageTypeTags.f_273918_)) {
            ADDITIONAL_DMG_RUNS.add(() -> ev.getEntity().m_6469_(ECDamageInit.heatDmgAttack(level, entity), (float)heatDmg));
        }
        if (voidDmg > 0.0 && !ev.getSource().m_269533_(DamageTypeTags.f_273918_)) {
            ADDITIONAL_DMG_RUNS.add(() -> ev.getEntity().m_6469_(ECDamageInit.voidDmgAttack(level, entity), (float)voidDmg));
        }
        if (soulDmg > 0.0 && !ev.getSource().m_269533_(DamageTypeTags.f_273918_)) {
            ADDITIONAL_DMG_RUNS.add(() -> ev.getEntity().m_6469_(ECDamageInit.soulDmgAttack(level, entity), (float)soulDmg));
        }
        if (!GeneralForgeEventBusEvents.entityHoldingWeapon(causingEntity) && gauntletDmg > 0.0 && !ev.getSource().m_269533_(DamageTypeTags.f_273918_)) {
            ADDITIONAL_DMG_RUNS.add(() -> ev.getEntity().m_6469_(ECDamageInit.gauntletAttack(level, entity), (float)gauntletDmg));
        }
    }

    public static boolean entityHoldingWeapon(LivingEntity entity) {
        Multimap mainHandAttributes = entity.m_21205_().m_41638_(EquipmentSlot.MAINHAND);
        Multimap offHandAttributes = entity.m_21206_().m_41638_(EquipmentSlot.OFFHAND);
        if (mainHandAttributes.containsKey((Object)Attributes.f_22281_)) {
            for (AttributeModifier modifier : mainHandAttributes.get((Object)Attributes.f_22281_)) {
                if (!(modifier.m_22218_() > 1.0)) continue;
                return true;
            }
        }
        if (offHandAttributes.containsKey((Object)Attributes.f_22281_)) {
            for (AttributeModifier modifier : offHandAttributes.get((Object)Attributes.f_22281_)) {
                if (!(modifier.m_22218_() > 1.0)) continue;
                return true;
            }
        }
        return false;
    }
}

