/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.userofbricks.expanded_combat.api.client.IGauntletRenderer;
import com.userofbricks.expanded_combat.item.ECGauntletItem;
import com.userofbricks.expanded_combat.item.ECQuiverItem;
import com.userofbricks.expanded_combat.plugins.CustomWeaponsPlugin;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber(modid="expanded_combat", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GauntletEvents {
    public static void DamageGauntletEvent(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.m_7500_()) {
            return;
        }
        List slotResults = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, itemStack -> itemStack.m_41720_() instanceof ECGauntletItem);
        if (slotResults.isEmpty()) {
            return;
        }
        for (SlotResult slotResult : slotResults) {
            ItemStack stack = slotResult.stack();
            SlotContext slotContext = slotResult.slotContext();
            if (!(stack.m_41720_() instanceof ECGauntletItem)) continue;
            stack.m_41622_(1, (LivingEntity)player, damager -> CuriosApi.getCuriosHelper().onBrokenCurio(slotContext));
        }
    }

    @SubscribeEvent
    public static void moreDamageSources(LivingAttackEvent ev) {
        LivingEntity target = ev.getEntity();
        Optional optionalSlotResult = CuriosApi.getCuriosHelper().findFirstCurio(target, (Item)CustomWeaponsPlugin.MAULERS.getGauntletEntry().get());
        if (optionalSlotResult.isPresent()) {
            SlotResult slotResult = (SlotResult)optionalSlotResult.get();
            int charge = slotResult.stack().m_41784_().m_128451_("charge");
            if (charge >= 20) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 2));
            } else {
                slotResult.stack().m_41784_().m_128405_("charge", charge + 1);
            }
        }
    }

    @SubscribeEvent
    public static void pulOutArrow(PlayerInteractEvent.RightClickEmpty event) {
        Player player = event.getEntity();
        Optional optionalSlotResult = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)CustomWeaponsPlugin.FIGHTER.getGauntletEntry().get());
        if (optionalSlotResult.isPresent() && player.m_21234_() >= 1) {
            LazyOptional lazyOptional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
            Optional optionalQuiverSlotResult = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> stack.m_41720_() instanceof ECQuiverItem);
            if (lazyOptional.resolve().isPresent() && optionalQuiverSlotResult.isPresent()) {
                ECQuiverItem quiverItem = (ECQuiverItem)((SlotResult)optionalQuiverSlotResult.get()).stack().m_41720_();
                IDynamicStackHandler arrowStackHandler = ((ICurioStacksHandler)((ICuriosItemHandler)lazyOptional.resolve().get()).getCurios().get("arrows")).getStacks();
                int slots = arrowStackHandler.getSlots();
                boolean found = false;
                for (int s = 0; s < slots; ++s) {
                    ItemStack currentStack = arrowStackHandler.getStackInSlot(s);
                    if (currentStack.m_41720_() != Items.f_42412_ && !currentStack.m_41619_() || quiverItem.providedSlots <= s) continue;
                    found = arrowStackHandler.insertItem(s, new ItemStack((ItemLike)Items.f_42412_), false).m_41619_();
                }
                if (!found) {
                    player.m_150109_().m_150079_(new ItemStack((ItemLike)Items.f_42412_));
                }
            } else {
                player.m_150109_().m_150079_(new ItemStack((ItemLike)Items.f_42412_));
            }
            player.m_21317_(player.m_21234_() - 1);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderArm(RenderArmEvent event) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)event.getPlayer()).ifPresent(handler -> {
            ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get(SlotTypePreset.HANDS.getIdentifier());
            if (stacksHandler != null) {
                ECGauntletItem ecGauntletItem;
                ICurioRenderer iCurioRenderer;
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStacks = stacksHandler.getCosmeticStacks();
                ItemStack stack = cosmeticStacks.getStackInSlot(0);
                boolean cosmetic = true;
                if (stack.m_41619_() && ((Boolean)stacksHandler.getRenders().get(0)).booleanValue()) {
                    stack = stacks.getStackInSlot(0);
                    cosmetic = false;
                }
                if (MinecraftForge.EVENT_BUS.post((Event)new GauntletRenderFirstPersonEvent(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getPlayer(), event.getArm(), stack, cosmetic))) {
                    return;
                }
                Item patt6720$temp = stack.m_41720_();
                if (patt6720$temp instanceof ECGauntletItem && (iCurioRenderer = (ecGauntletItem = (ECGauntletItem)patt6720$temp).getGauntletRenderer().get()) instanceof IGauntletRenderer) {
                    IGauntletRenderer gauntletRenderer = (IGauntletRenderer)iCurioRenderer;
                    gauntletRenderer.renderFirstPersonArm(stack, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getPlayer(), event.getArm(), stack.m_41790_());
                }
            }
        });
    }

    @Cancelable
    public static class GauntletRenderFirstPersonEvent
    extends Event {
        private final PoseStack poseStack;
        private final MultiBufferSource multiBufferSource;
        private final int packedLight;
        private final AbstractClientPlayer player;
        private final HumanoidArm arm;
        private final ItemStack gauntlet;
        private final boolean cosmetic;

        @ApiStatus.Internal
        public GauntletRenderFirstPersonEvent(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, AbstractClientPlayer player, HumanoidArm arm, ItemStack gauntlet, boolean cosmetic) {
            this.poseStack = poseStack;
            this.multiBufferSource = multiBufferSource;
            this.packedLight = packedLight;
            this.player = player;
            this.arm = arm;
            this.gauntlet = gauntlet;
            this.cosmetic = cosmetic;
        }

        public HumanoidArm getArm() {
            return this.arm;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }

        public MultiBufferSource getMultiBufferSource() {
            return this.multiBufferSource;
        }

        public int getPackedLight() {
            return this.packedLight;
        }

        public AbstractClientPlayer getPlayer() {
            return this.player;
        }

        public ItemStack getGauntlet() {
            return this.gauntlet;
        }

        public boolean isCosmetic() {
            return this.cosmetic;
        }
    }
}

