/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.events;

import com.tterrag.registrate.util.entry.RegistryEntry;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.WeaponMaterial;
import com.userofbricks.expanded_combat.init.MaterialInit;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="expanded_combat", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void PotionWeaponPotionDurability(RegisterItemDecorationsEvent event) {
        for (Material material : MaterialInit.weaponMaterials) {
            for (Map.Entry<String, RegistryEntry<? extends Item>> weaponEntry : material.getWeapons().entrySet()) {
                WeaponMaterial weaponMaterial = MaterialInit.valueOfWeapon(weaponEntry.getKey());
                if (weaponMaterial == null || !weaponMaterial.potionDippable()) continue;
                Item potionWeapon = (Item)weaponEntry.getValue().get();
                event.register((ItemLike)potionWeapon, (guiGraphics, font, stack, xOffset, yOffset) -> {
                    CompoundTag compoundTag = stack.m_41784_();
                    if (!compoundTag.m_128441_("PotionUses") || !compoundTag.m_128441_("MaxPotionUses")) {
                        return false;
                    }
                    int potionUses = compoundTag.m_128451_("PotionUses");
                    int maxPotionUses = compoundTag.m_128451_("MaxPotionUses");
                    if (potionUses != 0) {
                        guiGraphics.m_280168_().m_85836_();
                        int l = Math.round(13.0f - (float)(maxPotionUses - potionUses) * 13.0f / (float)maxPotionUses);
                        int i = Mth.m_14169_((float)0.75f, (float)0.2f, (float)0.9f);
                        int j = xOffset + 2;
                        int k = yOffset + 13;
                        if (stack.m_150947_()) {
                            guiGraphics.m_285944_(RenderType.m_286086_(), j, k, j + 13, k - 1, -16777216);
                            guiGraphics.m_285944_(RenderType.m_286086_(), j, k, j + l, k - 1, i | 0xFF000000);
                        } else {
                            guiGraphics.m_285944_(RenderType.m_286086_(), j, k, j + 13, k + 2, -16777216);
                            guiGraphics.m_285944_(RenderType.m_286086_(), j, k, j + l, k + 1, i | 0xFF000000);
                        }
                        guiGraphics.m_280168_().m_85849_();
                        return true;
                    }
                    return false;
                });
            }
        }
    }
}

