/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.datagen.loot;

import com.tterrag.registrate.util.entry.RegistryEntry;
import com.userofbricks.expanded_combat.init.ECItems;
import com.userofbricks.expanded_combat.loot.AddItemFromGauntletModifier;
import com.userofbricks.expanded_combat.loot.AddItemModifier;
import com.userofbricks.expanded_combat.loot.AddItemWithoutGauntletModifier;
import com.userofbricks.expanded_combat.plugins.CustomWeaponsPlugin;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;

public class ECGlobalLootModifiersProvider
extends GlobalLootModifierProvider {
    public ECGlobalLootModifiersProvider(PackOutput output) {
        super(output, "expanded_combat");
    }

    protected void start() {
        this.generateSoulLootModifiers();
        this.generateCustomWeaponLootModifiers();
    }

    private void generateCustomWeaponLootModifiers() {
        for (Map.Entry<String, RegistryEntry<? extends Item>> entry : CustomWeaponsPlugin.VOID_MATERIAL.getWeapons().entrySet()) {
            this.add("end_city_treasure_void_" + entry.getKey().toLowerCase().replace(" ", "_"), (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("chests/end_city_treasure")).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.05f).m_6409_()}, (Item)entry.getValue().get()));
        }
        for (String chestLoot : Arrays.asList("shipwreck_treasure", "underwater_ruin_big", "woodland_mansion", "buried_treasure")) {
            for (Map.Entry<String, RegistryEntry<? extends Item>> entry : CustomWeaponsPlugin.COLD_MATERIAL.getWeapons().entrySet()) {
                this.add(chestLoot + "_cold_" + entry.getKey().toLowerCase().replace(" ", "_"), (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("chests/" + chestLoot)).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.05f).m_6409_()}, (Item)entry.getValue().get()));
            }
        }
        for (String chestLoot : Arrays.asList("desert_pyramid", "bastion_treasure", "woodland_mansion", "buried_treasure")) {
            for (Map.Entry<String, RegistryEntry<? extends Item>> entry : CustomWeaponsPlugin.HEAT_MATERIAL.getWeapons().entrySet()) {
                this.add(chestLoot + "_heat_" + entry.getKey().toLowerCase().replace(" ", "_"), (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("chests/" + chestLoot)).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.05f).m_6409_()}, (Item)entry.getValue().get()));
            }
        }
        for (String chestLoot : Arrays.asList("ancient_city", "bastion_treasure", "woodland_mansion")) {
            for (Map.Entry<String, RegistryEntry<? extends Item>> entry : CustomWeaponsPlugin.SOUL_MATERIAL.getWeapons().entrySet()) {
                this.add(chestLoot + "_soul_" + entry.getKey().toLowerCase().replace(" ", "_"), (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("chests/" + chestLoot)).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.05f).m_6409_()}, (Item)entry.getValue().get()));
            }
        }
        this.add("bastion_treasure_fighters_gauntlet", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("chests/bastion_treasure")).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.05f).m_6409_()}, (Item)CustomWeaponsPlugin.FIGHTER.getGauntletEntry().get()));
        this.add("woodland_mansion_gauntlet", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("chests/woodland_mansion")).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.05f).m_6409_()}, (Item)CustomWeaponsPlugin.GAUNTLET.getGauntletEntry().get()));
        this.add("pillager_outpost_soul_gauntlet", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("chests/pillager_outpost")).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.05f).m_6409_()}, (Item)CustomWeaponsPlugin.MAULERS.getGauntletEntry().get()));
        this.add("ancient_city_soul_gauntlet", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("chests/ancient_city")).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.05f).m_6409_()}, (Item)CustomWeaponsPlugin.SOUL_MATERIAL.getGauntletEntry().get()));
    }

    private void generateSoulLootModifiers() {
        AllOfCondition.Builder soulWeaponChance = AllOfCondition.m_285871_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate)new EntityPredicate.Builder().m_36640_(new EntityEquipmentPredicate.Builder().m_149928_(new ItemPredicate(null, CustomWeaponsPlugin.SOUL_MATERIAL.getWeapons().values().stream().map(RegistryEntry::get).collect(Collectors.toSet()), MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)).m_32207_()).m_36662_()), LootItemRandomChanceCondition.m_81927_((float)0.2f)});
        for (String mob : Arrays.asList("blaze", "cave_spider", "creeper", "ender_dragon", "endermite", "evoker", "guardian", "hoglin", "illusioner", "magma_cube", "piglin", "piglin_brute", "pillager", "ravager", "silverfish", "slime", "spider", "vindicator", "witch", "wither_skeleton")) {
            this.add("bad_soul_from_" + mob + "_with_soul_gauntlet", (IGlobalLootModifier)new AddItemFromGauntletModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("entities/" + mob)).m_6409_(), AnyOfCondition.m_285758_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemRandomChanceCondition.m_81927_((float)0.01f), soulWeaponChance}).m_6409_()}, (Item)ECItems.BAD_SOUL.get(), (Item)CustomWeaponsPlugin.SOUL_MATERIAL.getGauntletEntry().get()));
            this.add("bad_soul_from_" + mob + "_without_soul_gauntlet", (IGlobalLootModifier)new AddItemWithoutGauntletModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("entities/" + mob)).m_6409_(), soulWeaponChance.m_6409_()}, (Item)ECItems.BAD_SOUL.get(), (Item)CustomWeaponsPlugin.SOUL_MATERIAL.getGauntletEntry().get()));
        }
        for (String mob : Arrays.asList("drowned", "enderman", "ghast", "giant", "husk", "phantom", "shulker", "skeleton", "skeleton_horse", "stray", "vex", "zoglin", "zombie", "zombie_horse", "zombie_villager", "zombified_piglin")) {
            this.add("good_soul_from_" + mob + "_with_soul_gauntlet", (IGlobalLootModifier)new AddItemFromGauntletModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("entities/" + mob)).m_6409_(), AnyOfCondition.m_285758_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemRandomChanceCondition.m_81927_((float)0.01f), soulWeaponChance}).m_6409_()}, (Item)ECItems.GOOD_SOUL.get(), (Item)CustomWeaponsPlugin.SOUL_MATERIAL.getGauntletEntry().get()));
            this.add("good_soul_from_" + mob + "_without_soul_gauntlet", (IGlobalLootModifier)new AddItemWithoutGauntletModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("entities/" + mob)).m_6409_(), soulWeaponChance.m_6409_()}, (Item)ECItems.GOOD_SOUL.get(), (Item)CustomWeaponsPlugin.SOUL_MATERIAL.getGauntletEntry().get()));
        }
        for (String mob : Arrays.asList("wither", "warden", "elder_guardian")) {
            this.add("bad_soul_from_" + mob + "_with_soul_gauntlet", (IGlobalLootModifier)new AddItemFromGauntletModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("entities/" + mob)).m_6409_(), AnyOfCondition.m_285758_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemRandomChanceCondition.m_81927_((float)0.1f), soulWeaponChance}).m_6409_()}, (Item)ECItems.BAD_SOUL.get(), (Item)CustomWeaponsPlugin.SOUL_MATERIAL.getGauntletEntry().get()));
            this.add("bad_soul_from_" + mob + "_without_soul_gauntlet", (IGlobalLootModifier)new AddItemWithoutGauntletModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("entities/" + mob)).m_6409_(), soulWeaponChance.m_6409_()}, (Item)ECItems.BAD_SOUL.get(), (Item)CustomWeaponsPlugin.SOUL_MATERIAL.getGauntletEntry().get()));
        }
        for (String mob : Arrays.asList("wither", "warden")) {
            this.add("good_soul_from_" + mob + "_with_soul_gauntlet", (IGlobalLootModifier)new AddItemFromGauntletModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("entities/" + mob)).m_6409_(), AnyOfCondition.m_285758_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemRandomChanceCondition.m_81927_((float)0.1f), soulWeaponChance}).m_6409_()}, (Item)ECItems.GOOD_SOUL.get(), (Item)CustomWeaponsPlugin.SOUL_MATERIAL.getGauntletEntry().get()));
            this.add("good_soul_from_" + mob + "_without_soul_gauntlet", (IGlobalLootModifier)new AddItemWithoutGauntletModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation("entities/" + mob)).m_6409_(), soulWeaponChance.m_6409_()}, (Item)ECItems.GOOD_SOUL.get(), (Item)CustomWeaponsPlugin.SOUL_MATERIAL.getGauntletEntry().get()));
        }
    }
}

