/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.datagen.bettercombat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class BetterCombatWeaponAttributesProvider
implements DataProvider {
    private final PackOutput output;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<String, ResourceLocation> builders = Maps.newLinkedHashMap();

    public BetterCombatWeaponAttributesProvider(PackOutput output, String modId, ExistingFileHelper helper) {
        this.output = output;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerTransforms();

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        this.builders.clear();
        this.registerTransforms();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.builders.forEach((name, transform) -> {
            List<String> list = this.builders.keySet().stream().filter(s -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(this.modId, name))).filter(s -> !this.builders.containsKey(s)).filter(this::missing).toList();
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Weapon Attributes: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((ResourceLocation)transform);
            Path path = this.createPath(new ResourceLocation(this.modId, name));
            futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)cache, (JsonElement)obj, (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    private boolean missing(String name) {
        return this.helper == null || !this.helper.exists(new ResourceLocation(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "weapon_attributes"));
    }

    private Path createPath(ResourceLocation name) {
        return this.output.m_245114_().resolve("data/" + name.m_135827_() + "/weapon_attributes/" + name.m_135815_() + ".json");
    }

    private JsonObject serializeToJson(ResourceLocation transform) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("parent", transform.toString());
        return jsonObject;
    }

    @NotNull
    public String m_6055_() {
        return this.modId + " Better Combat Weapon Attributes";
    }

    public void add(Item weapon, ResourceLocation weaponAtrributesParent) {
        this.builders.put(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)weapon)).m_135815_(), weaponAtrributesParent);
    }

    public void add(Item weapon, String weaponAtrributesParent) {
        this.add(weapon, new ResourceLocation("bettercombat", weaponAtrributesParent));
    }
}

