/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.config;

import com.userofbricks.expanded_combat.config.ConfigName;
import com.userofbricks.expanded_combat.config.TooltipFrase;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

public class WeaponMaterialConfig {
    @ConfigName(value="Durability Multiplier")
    public double durabilityMultiplier;
    @ConfigName(value="Base Attack Damage")
    @ConfigEntry.Gui.Tooltip
    @TooltipFrase(value="Material tool damage is added to this")
    public int baseAttackDamage;
    @ConfigName(value="Attack Speed")
    public float attackSpeed;
    @ConfigName(value="Mending Bonus")
    public float mendingBonus;
    @ConfigName(value="Knockback")
    public float knockback;
    @ConfigName(value="Added Attack Range")
    @ConfigEntry.Gui.Tooltip
    @TooltipFrase(value="In Blocks")
    public double attackRange;
    @ConfigName(value="Grip Type")
    public WieldingType wieldType;

    WeaponMaterialConfig(double durabilityMultiplier, int baseAttackDamage, float attackSpeed, double attackRange, float knockback, float mendingBonus, WieldingType wieldType) {
        this.durabilityMultiplier = durabilityMultiplier;
        this.baseAttackDamage = baseAttackDamage;
        this.attackSpeed = attackSpeed;
        this.attackRange = attackRange;
        this.mendingBonus = mendingBonus;
        this.knockback = knockback;
        this.wieldType = wieldType;
    }

    public static enum WieldingType {
        ONEHANDED,
        TWOHANDED,
        DUALWIELD;

    }

    public static class Builder {
        public boolean hasLargeModel = false;
        private double durabilityMultiplier = 1.0;
        private int baseAttackDamage = 0;
        private float attackSpeed = 0.0f;
        private float mendingBonus = 0.0f;
        private float knockback = 0.0f;
        private double attackRange = 0.0;
        private final WieldingType wieldType;

        public Builder(WieldingType wieldType) {
            this.wieldType = wieldType;
        }

        public Builder durabilityMultiplier(double multiplier) {
            this.durabilityMultiplier = multiplier;
            return this;
        }

        public Builder baseAttackDamage(int damage) {
            this.baseAttackDamage = damage;
            return this;
        }

        public Builder attackSpeed(float speed) {
            this.attackSpeed = speed;
            return this;
        }

        public Builder mendingBonus(float bonus) {
            this.mendingBonus = bonus;
            return this;
        }

        public Builder knockback(float knockback) {
            this.knockback = knockback;
            return this;
        }

        public Builder attackRange(double range) {
            this.attackRange = range;
            return this;
        }

        public Builder hasLargeModel() {
            this.hasLargeModel = true;
            return this;
        }

        public WeaponMaterialConfig build() {
            return new WeaponMaterialConfig(this.durabilityMultiplier, this.baseAttackDamage, this.attackSpeed, this.attackRange, this.knockback, this.mendingBonus, this.wieldType);
        }
    }
}

