/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.compatability.jei.recipes;

import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.registry.ShieldToMaterials;
import com.userofbricks.expanded_combat.init.ECItems;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.item.recipes.IShieldSmithingRecipe;
import com.userofbricks.expanded_combat.item.recipes.StanderStyleShieldSmithingRecipe;
import com.userofbricks.expanded_combat.plugins.VanillaECPlugin;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IStackHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ECShieldSmithingRecipeMaker {
    public static List<IShieldSmithingRecipe> createShieldSmithingRecipes(IStackHelper stackHelper) {
        ArrayList<IShieldSmithingRecipe> recipes = new ArrayList<IShieldSmithingRecipe>();
        ArrayList<ItemStack> bases = new ArrayList<ItemStack>();
        bases.add(new ItemStack((ItemLike)Items.f_42740_));
        for (ShieldToMaterials shieldToMaterials : MaterialInit.shieldToMaterialsList) {
            bases.add(new ItemStack(shieldToMaterials.itemLikeSupplier().get()));
        }
        for (Material material : MaterialInit.shieldMaterials) {
            ItemStack shield = new ItemStack(material.getConfig().fireResistant ? (ItemLike)ECItems.SHIELD_TIER_3.get() : (ItemLike)ECItems.SHIELD_TIER_1.get());
            shield.m_41784_().m_128359_("UL_Material", material.getName());
            shield.m_41784_().m_128359_("UR_Material", material.getName());
            shield.m_41784_().m_128359_("DL_Material", material.getName());
            shield.m_41784_().m_128359_("DR_Material", material.getName());
            shield.m_41784_().m_128359_("M_Material", material.shieldUse == Material.ShieldUse.NOT_TRIM ? VanillaECPlugin.IRON.getName() : material.getName());
            bases.add(shield);
        }
        for (Material material : MaterialInit.shieldMaterials) {
            Ingredient addition = Ingredient.m_43929_((ItemLike[])IngredientUtil.toItemLikeArray(material.getConfig().crafting.repairItem));
            if (addition.m_43947_() || addition.test(ItemStack.f_41583_) || addition.test(new ItemStack((ItemLike)Items.f_41852_))) continue;
            ItemStack resultShield = new ItemStack(material.getConfig().fireResistant ? (ItemLike)ECItems.SHIELD_TIER_3.get() : (ItemLike)ECItems.SHIELD_TIER_1.get());
            resultShield.m_41784_().m_128359_("UL_Material", material.getName());
            resultShield.m_41784_().m_128359_("UR_Material", material.getName());
            resultShield.m_41784_().m_128359_("DL_Material", material.getName());
            resultShield.m_41784_().m_128359_("DR_Material", material.getName());
            if (material.shieldUse == Material.ShieldUse.ALL) {
                resultShield.m_41784_().m_128359_("M_Material", material.getName());
            } else {
                resultShield.m_41784_().m_128359_("M_Material", VanillaECPlugin.IRON.getName());
            }
            ResourceLocation id = new ResourceLocation("expanded_combat", "jei.shield.smithing." + resultShield.m_41778_());
            if (material.getConfig().crafting.isSingleAddition && material.getCraftedFrom() != null) {
                ItemStack baseShield = new ItemStack(material.getCraftedFrom().getConfig().fireResistant ? (ItemLike)ECItems.SHIELD_TIER_3.get() : (ItemLike)ECItems.SHIELD_TIER_1.get());
                baseShield.m_41784_().m_128359_("UL_Material", material.getCraftedFrom().getName());
                baseShield.m_41784_().m_128359_("UR_Material", material.getCraftedFrom().getName());
                baseShield.m_41784_().m_128359_("DL_Material", material.getCraftedFrom().getName());
                baseShield.m_41784_().m_128359_("DR_Material", material.getCraftedFrom().getName());
                baseShield.m_41784_().m_128359_("M_Material", material.getCraftedFrom().getName());
                recipes.add(new StanderStyleShieldSmithingRecipe(id, Ingredient.m_43927_((ItemStack[])new ItemStack[]{baseShield}), Ingredient.f_43901_, Ingredient.f_43901_, addition, Ingredient.f_43901_, Ingredient.f_43901_, resultShield));
                continue;
            }
            Ingredient basesIngrediant = Ingredient.m_43921_(bases.stream());
            Ingredient ironIngotIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_});
            if (material.shieldUse == Material.ShieldUse.ALL) {
                recipes.add(new StanderStyleShieldSmithingRecipe(id, basesIngrediant, addition, resultShield));
                continue;
            }
            recipes.add(new StanderStyleShieldSmithingRecipe(id, basesIngrediant, addition, addition, ironIngotIngredient, addition, addition, resultShield));
        }
        return recipes;
    }
}

