/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.compatability.jei.recipes;

import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.init.ECItems;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.item.ECShieldItem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.StreamSupport;
import mezz.jei.api.helpers.IStackHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ECShieldDecorationRecipeMaker {
    public static List<CraftingRecipe> createRecipes(IStackHelper stackHelper) {
        Iterable banners = BuiltInRegistries.f_257033_.m_206058_(ItemTags.f_13191_);
        EnumSet<DyeColor> colors = EnumSet.noneOf(DyeColor.class);
        ArrayList<CraftingRecipe> craftingRecipes = new ArrayList<CraftingRecipe>();
        for (Material shieldMaterial : MaterialInit.shieldMaterials) {
            List<CraftingRecipe> craftingRecipesForShield = StreamSupport.stream(banners.spliterator(), false).filter(Holder::m_203633_).map(Holder::m_203334_).filter(BannerItem.class::isInstance).map(BannerItem.class::cast).filter(item -> colors.add(item.m_40545_())).map(banner -> ECShieldDecorationRecipeMaker.createRecipe(banner, shieldMaterial)).toList();
            craftingRecipes.addAll(craftingRecipesForShield);
        }
        return craftingRecipes;
    }

    private static CraftingRecipe createRecipe(BannerItem banner, Material shieldMaterial) {
        ItemStack shieldStack = ECShieldItem.makeShieldBeMaterial(new ItemStack(shieldMaterial.getConfig().fireResistant ? (ItemLike)ECItems.SHIELD_TIER_3.get() : (ItemLike)ECItems.SHIELD_TIER_1.get()), shieldMaterial);
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{shieldStack}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{banner})});
        ItemStack output = ECShieldDecorationRecipeMaker.createOutput(banner, shieldStack.m_41777_());
        ResourceLocation id = new ResourceLocation("minecraft", "jei.ec_shield.decoration." + output.m_41778_() + "_" + shieldMaterial.getLocationName().m_135827_() + "_" + shieldMaterial.getLocationName().m_135815_());
        return new ShapelessRecipe(id, "jei.ec_shield.decoration", CraftingBookCategory.MISC, output, inputs);
    }

    private static ItemStack createOutput(BannerItem banner, ItemStack output) {
        DyeColor color = banner.m_40545_();
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Base", color.m_41060_());
        BlockItem.m_186338_((ItemStack)output, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)tag);
        return output;
    }
}

