/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.compatability.jei.recipe_category;

import com.userofbricks.expanded_combat.item.recipes.FletchingRecipe;
import com.userofbricks.expanded_combat.item.recipes.IFletchingRecipe;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FletchingRecipeCategory
implements IRecipeCategory<IFletchingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final ITickTimer tickTimer;
    public static final ResourceLocation textureLocation = new ResourceLocation("expanded_combat", "textures/gui/jei/recipe_backgrounds.png");
    public static final RecipeType<IFletchingRecipe> FLETCHING = RecipeType.create((String)"expanded_combat", (String)"fletching", IFletchingRecipe.class);

    public FletchingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(textureLocation, 0, 0, 125, 18);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50622_));
        this.tickTimer = guiHelper.createTickTimer(256, 64, false);
    }

    public RecipeType<IFletchingRecipe> getRecipeType() {
        return FLETCHING;
    }

    public Component getTitle() {
        return Blocks.f_50622_.m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IFletchingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if ((this.tickTimer.getValue() != 0 || this.tickTimer.getValue() != 1) && recipe.getMaxCraftingAmount() > 1) {
            guiGraphics.m_280168_().m_85836_();
            this.drawAcendingNumbers(guiGraphics, 7, 12, recipe.getMaxCraftingAmount());
            this.drawAcendingNumbers(guiGraphics, 114, 12, recipe.getMaxCraftingAmount());
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void drawAcendingNumbers(GuiGraphics guiGraphics, int offsetX, int offsetY, int maxRecipeRepeats) {
        int firstNumber = this.tickTimer.getValue() / 10;
        int secondNumber = this.tickTimer.getValue() % 10;
        if (maxRecipeRepeats / 10 < firstNumber) {
            return;
        }
        if (maxRecipeRepeats / 10 == firstNumber && maxRecipeRepeats % 10 < secondNumber) {
            return;
        }
        int width = 8;
        int height = 10;
        int firstNumTexX = firstNumber * width;
        int secondNumTexX = secondNumber * width;
        int numTexY = 18;
        for (int i = 0; i < 2; ++i) {
            int numTexX;
            int n = numTexX = i == 0 ? firstNumTexX : secondNumTexX;
            if (i != 0 || this.tickTimer.getValue() >= 10) {
                guiGraphics.m_280218_(textureLocation, offsetX, offsetY, numTexX, numTexY, width, height);
            }
            offsetX += 6;
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFletchingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.getBase());
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients(recipe.getAddition());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
    }

    public boolean isHandled(IFletchingRecipe recipe) {
        return recipe instanceof FletchingRecipe;
    }
}

