/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.compatability.jei;

import com.tterrag.registrate.util.entry.RegistryEntry;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.client.renderer.gui.screen.inventory.FletchingTableScreen;
import com.userofbricks.expanded_combat.client.renderer.gui.screen.inventory.ShieldSmithingTableScreen;
import com.userofbricks.expanded_combat.compatability.jei.ECRecipes;
import com.userofbricks.expanded_combat.compatability.jei.container_handelers.CuriosContainerHandler;
import com.userofbricks.expanded_combat.compatability.jei.item_subtype.ShieldSubtypeInterpreter;
import com.userofbricks.expanded_combat.compatability.jei.recipe_category.FletchingRecipeCategory;
import com.userofbricks.expanded_combat.compatability.jei.recipe_category.ShieldSmithingRecipeCategory;
import com.userofbricks.expanded_combat.compatability.jei.recipes.ECFletchingTippedArrowRecipeMaker;
import com.userofbricks.expanded_combat.compatability.jei.recipes.ECPotionWeaponRecipeMaker;
import com.userofbricks.expanded_combat.compatability.jei.recipes.ECShieldDecorationRecipeMaker;
import com.userofbricks.expanded_combat.compatability.jei.recipes.ECShieldSmithingRecipeMaker;
import com.userofbricks.expanded_combat.compatability.jei.recipes.ECTippedArrowRecipeMaker;
import com.userofbricks.expanded_combat.init.ECContainers;
import com.userofbricks.expanded_combat.init.ECItems;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.inventory.container.FletchingTableMenu;
import com.userofbricks.expanded_combat.inventory.container.ShieldSmithingMenu;
import com.userofbricks.expanded_combat.item.ECArrowItem;
import com.userofbricks.expanded_combat.item.ECWeaponItem;
import com.userofbricks.expanded_combat.item.recipes.IFletchingRecipe;
import com.userofbricks.expanded_combat.item.recipes.IShieldSmithingRecipe;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.plugins.vanilla.brewing.PotionSubtypeInterpreter;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.client.gui.CuriosScreenV2;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class ECJEIPlugin
implements IModPlugin {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private IRecipeCategory<IFletchingRecipe> fletchingCategory;
    @Nullable
    private IRecipeCategory<IShieldSmithingRecipe> shieldSmithingCategory;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("expanded_combat", "jei_plugin");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Material material : MaterialInit.arrowMaterials) {
            registration.registerSubtypeInterpreter((Item)material.getTippedArrowEntry().get(), (IIngredientSubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        }
        for (Material material : MaterialInit.weaponMaterials) {
            material.getWeapons().forEach((weaponName, registryEntry) -> {
                if (registryEntry.get() instanceof ECWeaponItem.HasPotion) {
                    registration.registerSubtypeInterpreter((Item)registryEntry.get(), (IIngredientSubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
                }
            });
        }
        registration.registerSubtypeInterpreter((Item)ECItems.SHIELD_TIER_1.get(), (IIngredientSubtypeInterpreter)ShieldSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter((Item)ECItems.SHIELD_TIER_2.get(), (IIngredientSubtypeInterpreter)ShieldSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter((Item)ECItems.SHIELD_TIER_3.get(), (IIngredientSubtypeInterpreter)ShieldSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter((Item)ECItems.SHIELD_TIER_4.get(), (IIngredientSubtypeInterpreter)ShieldSubtypeInterpreter.INSTANCE);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.shieldSmithingCategory = new ShieldSmithingRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this.shieldSmithingCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
        if (!ModList.get().isLoaded("apotheosis")) {
            IRecipeCategory[] iRecipeCategoryArray2 = new IRecipeCategory[1];
            this.fletchingCategory = new FletchingRecipeCategory(guiHelper);
            iRecipeCategoryArray2[0] = this.fletchingCategory;
            registration.addRecipeCategories(iRecipeCategoryArray2);
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ErrorUtil.checkNotNull(this.shieldSmithingCategory, (String)"shieldSmithingCategory");
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        ECRecipes vanillaRecipes = new ECRecipes(ingredientManager);
        for (Material material : MaterialInit.arrowMaterials) {
            registration.addRecipes(RecipeTypes.CRAFTING, ECTippedArrowRecipeMaker.createRecipes(stackHelper, (ECArrowItem)((Object)material.getArrowEntry().get())));
        }
        for (RegistryEntry registryEntry : ECItems.ITEMS) {
            if (!(registryEntry.get() instanceof ECWeaponItem.HasPotion)) continue;
            registration.addRecipes(RecipeTypes.CRAFTING, ECPotionWeaponRecipeMaker.createRecipes(stackHelper, (ECWeaponItem.HasPotion)registryEntry.get()));
        }
        if (this.fletchingCategory != null) {
            registration.addRecipes(FletchingRecipeCategory.FLETCHING, vanillaRecipes.getFletchingRecipes(this.fletchingCategory));
            registration.addRecipes(FletchingRecipeCategory.FLETCHING, ECFletchingTippedArrowRecipeMaker.createTippedArrowRecipes(stackHelper));
        }
        registration.addRecipes(ShieldSmithingRecipeCategory.SHIELD_SMITHING, vanillaRecipes.getShieldSmithingRecipes(this.shieldSmithingCategory));
        registration.addRecipes(ShieldSmithingRecipeCategory.SHIELD_SMITHING, ECShieldSmithingRecipeMaker.createShieldSmithingRecipes(stackHelper));
        registration.addRecipes(RecipeTypes.CRAFTING, ECShieldDecorationRecipeMaker.createRecipes(stackHelper));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (this.fletchingCategory != null) {
            registration.addRecipeTransferHandler(FletchingTableMenu.class, (MenuType)ECContainers.FLETCHING.get(), FletchingRecipeCategory.FLETCHING, 0, 2, 3, 36);
        }
        registration.addRecipeTransferHandler(ShieldSmithingMenu.class, (MenuType)ECContainers.SHIELD_SMITHING.get(), ShieldSmithingRecipeCategory.SHIELD_SMITHING, 0, 6, 7, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (this.fletchingCategory != null) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50622_), new RecipeType[]{FletchingRecipeCategory.FLETCHING});
        }
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50625_), new RecipeType[]{ShieldSmithingRecipeCategory.SHIELD_SMITHING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (this.fletchingCategory != null) {
            registration.addRecipeClickArea(FletchingTableScreen.class, 102, 48, 22, 15, new RecipeType[]{FletchingRecipeCategory.FLETCHING});
        }
        registration.addRecipeClickArea(ShieldSmithingTableScreen.class, 102, 48, 22, 15, new RecipeType[]{ShieldSmithingRecipeCategory.SHIELD_SMITHING});
        registration.addGuiContainerHandler(CuriosScreenV2.class, (IGuiContainerHandler)new CuriosContainerHandler());
    }
}

