/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.userofbricks.expanded_combat.init.LangStrings;
import com.userofbricks.expanded_combat.network.ECVariables;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CommandSetAddedHearts {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(p_137029_ -> Component.m_237110_((String)LangStrings.createCommandLang("added_hearts", false, "entity", "%s is not a valid entity for this command"), (Object[])new Object[]{p_137029_}));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)LangStrings.createCommandLang("added_hearts", false, "nothing", "Nothing changed.")));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"SetAddedHearts").requires(cs -> cs.m_6761_(1))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(commandSourceStackSource -> CommandSetAddedHearts.setAddedHearts((CommandSourceStack)commandSourceStackSource.getSource(), EntityArgument.m_91461_((CommandContext)commandSourceStackSource, (String)"targets"), (Integer)commandSourceStackSource.getArgument("amount", Integer.class)))));
    }

    private static int setAddedHearts(CommandSourceStack source, Collection<? extends Entity> targets, Integer amount) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ECVariables.setAddedHealth(livingEntity, amount);
                ++i;
                continue;
            }
            if (targets.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.m_7755_().getString());
        }
        if (i == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)LangStrings.createCommandLang("increase_charge", true, "single", "Set Stolen Hearts to %s for %s"), (Object[])new Object[]{amount, ((Entity)targets.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)LangStrings.createCommandLang("increase_charge", true, "multiple", "Set Stolen Hearts to %s for %s entities"), (Object[])new Object[]{amount, targets.size()}), true);
        }
        return i;
    }
}

