/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.client.sprites;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.userofbricks.expanded_combat.init.SpriteSourceTypes;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.textures.ForgeTextureMetadata;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PalettedFolderPermutations
implements SpriteSource {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<PalettedFolderPermutations> CODEC = RecordCodecBuilder.create(p_266838_ -> p_266838_.group((App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("textures").forGetter(p_267300_ -> p_267300_.textures), (App)ResourceLocation.f_135803_.fieldOf("palette_key").forGetter(p_266732_ -> p_266732_.paletteKey), (App)Codec.BOOL.fieldOf("texture_name_as_folder").forGetter(palette -> palette.textureNameAsFolder), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.f_135803_).fieldOf("permutations").forGetter(p_267234_ -> p_267234_.permutations)).apply((Applicative)p_266838_, PalettedFolderPermutations::new));
    private final List<ResourceLocation> textures;
    private final Map<String, ResourceLocation> permutations;
    private final ResourceLocation paletteKey;
    private final boolean textureNameAsFolder;

    public PalettedFolderPermutations(List<ResourceLocation> textures, ResourceLocation paletteKey, boolean textureNameAsFolder, Map<String, ResourceLocation> permutations) {
        this.textures = textures;
        this.textureNameAsFolder = textureNameAsFolder;
        this.permutations = permutations;
        this.paletteKey = paletteKey;
    }

    public void m_260891_(ResourceManager resourceManager, SpriteSource.Output output) {
        Supplier supplier = Suppliers.memoize(() -> PalettedPermutations.m_266592_((ResourceManager)resourceManager, (ResourceLocation)this.paletteKey));
        HashMap map = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> PalettedFolderPermutations.lambda$run$7(map, (java.util.function.Supplier)supplier, resourceManager, arg_0, arg_1));
        for (ResourceLocation resourcelocation : this.textures) {
            ResourceLocation resourcelocation1 = f_266012_.m_245698_(resourcelocation);
            Optional optional = resourceManager.m_213713_(resourcelocation1);
            if (optional.isEmpty()) {
                LOGGER.warn("Unable to find texture {}", (Object)resourcelocation1);
                continue;
            }
            LazyLoadedImage lazyloadedimage = new LazyLoadedImage(resourcelocation1, (Resource)optional.get(), map.size());
            for (Map.Entry entry : map.entrySet()) {
                ResourceLocation resourcelocation2 = resourcelocation.m_266382_((this.textureNameAsFolder ? "/" : "_") + (String)entry.getKey());
                output.m_260840_(resourcelocation2, (SpriteSource.SpriteSupplier)new PalettedSpriteSupplier(lazyloadedimage, (java.util.function.Supplier)entry.getValue(), resourcelocation2));
            }
        }
    }

    private static IntUnaryOperator createPaletteMapping(int[] key, int[] permutation) {
        if (permutation.length != key.length) {
            LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)key.length, (Object)permutation.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2intmap = new Int2IntOpenHashMap(permutation.length);
        for (int i = 0; i < key.length; ++i) {
            int j = key[i];
            if (FastColor.ABGR32.m_266503_((int)j) == 0) continue;
            int2intmap.put(FastColor.ABGR32.m_266533_((int)j), permutation[i]);
        }
        return arg_0 -> PalettedFolderPermutations.lambda$createPaletteMapping$8((Int2IntMap)int2intmap, arg_0);
    }

    public SpriteSourceType m_260850_() {
        return SpriteSourceTypes.PALETTED_FOLDER_PERMUTATIONS;
    }

    private static /* synthetic */ int lambda$createPaletteMapping$8(Int2IntMap int2intmap, int colorInt) {
        int k = FastColor.ABGR32.m_266503_((int)colorInt);
        if (k == 0) {
            return colorInt;
        }
        int l = FastColor.ABGR32.m_266533_((int)colorInt);
        int i1 = int2intmap.getOrDefault(l, FastColor.ABGR32.m_267818_((int)l));
        int j1 = FastColor.ABGR32.m_266503_((int)i1);
        return FastColor.ABGR32.m_266498_((int)(k * j1 / 255), (int)i1);
    }

    private static /* synthetic */ void lambda$run$7(Map map, java.util.function.Supplier supplier, ResourceManager resourceManager, String string, ResourceLocation resourceLocation) {
        map.put(string, Suppliers.memoize(() -> PalettedFolderPermutations.lambda$run$6((java.util.function.Supplier)supplier, resourceManager, resourceLocation)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$6(java.util.function.Supplier supplier, ResourceManager resourceManager, ResourceLocation resourceLocation) {
        return PalettedFolderPermutations.createPaletteMapping((int[])supplier.get(), PalettedPermutations.m_266592_((ResourceManager)resourceManager, (ResourceLocation)resourceLocation));
    }

    @OnlyIn(value=Dist.CLIENT)
    record PalettedSpriteSupplier(LazyLoadedImage baseImage, java.util.function.Supplier<IntUnaryOperator> palette, ResourceLocation permutationLocation) implements SpriteSource.SpriteSupplier
    {
        @Nullable
        public SpriteContents get() {
            try {
                NativeImage nativeimage = this.baseImage.m_266167_().m_266528_(this.palette.get());
                SpriteContents spriteContents = new SpriteContents(this.permutationLocation, new FrameSize(nativeimage.m_84982_(), nativeimage.m_85084_()), nativeimage, AnimationMetadataSection.f_119012_, ForgeTextureMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException ioexception) {
                LOGGER.error("unable to apply palette to {}", (Object)this.permutationLocation, (Object)ioexception);
            }
            finally {
                this.baseImage.m_266458_();
            }
            return null;
        }

        public void m_260986_() {
            this.baseImage.m_266458_();
        }
    }
}

