/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.client.sprites;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.userofbricks.expanded_combat.init.SpriteSourceTypes;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.textures.ForgeTextureMetadata;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AlphaMaskFolderPermutations
implements SpriteSource {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<AlphaMaskFolderPermutations> CODEC = RecordCodecBuilder.create(p_266838_ -> p_266838_.group((App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("permutations").forGetter(p_267300_ -> p_267300_.permutations), (App)Codec.BOOL.fieldOf("mask_name_as_folder").forGetter(palette -> palette.maskNameAsFolder), (App)Codec.STRING.fieldOf("source").forGetter(p_261592_ -> p_261592_.sourcePath)).apply((Applicative)p_266838_, AlphaMaskFolderPermutations::new));
    private final List<ResourceLocation> permutations;
    private final String sourcePath;
    private final boolean maskNameAsFolder;

    public AlphaMaskFolderPermutations(List<ResourceLocation> permutations, boolean maskNameAsFolder, String sourcePath) {
        this.permutations = permutations;
        this.maskNameAsFolder = maskNameAsFolder;
        this.sourcePath = sourcePath;
    }

    public void m_260891_(ResourceManager resourceManager, SpriteSource.Output output) {
        for (ResourceLocation maskSpriteLocation : this.permutations) {
            ResourceLocation maskFileLocation = f_266012_.m_245698_(maskSpriteLocation);
            Optional optionalMaskResource = resourceManager.m_213713_(maskFileLocation);
            if (optionalMaskResource.isEmpty()) {
                LOGGER.warn("Unable to find mask texture {}", (Object)maskFileLocation);
                continue;
            }
            FileToIdConverter filetoidconverter = new FileToIdConverter("textures/" + this.sourcePath, ".png");
            Map foundTextures = filetoidconverter.m_247457_(resourceManager);
            LazyLoadedImage lazyMaskImage = new LazyLoadedImage(maskFileLocation, (Resource)optionalMaskResource.get(), foundTextures.size());
            foundTextures.forEach((textureFileLocation, resource) -> {
                try (InputStream inputstream = resource.m_215507_();){
                    NativeImage baseImage = NativeImage.m_85058_((InputStream)inputstream);
                    ResourceLocation finalSpriteLocation = textureFileLocation.m_247449_(maskSpriteLocation.m_266382_((this.maskNameAsFolder ? "/" : "_") + this.getTextureFileName((ResourceLocation)textureFileLocation)).m_135815_());
                    output.m_260840_(finalSpriteLocation, (SpriteSource.SpriteSupplier)new MaskedSpriteSupplier(baseImage, lazyMaskImage, finalSpriteLocation));
                }
                catch (IOException ioexception) {
                    LOGGER.error("Using missing texture, unable to load {}", (Object)filetoidconverter.m_245273_(textureFileLocation).m_246208_(this.sourcePath + "/"), (Object)ioexception);
                }
            });
        }
    }

    private String getTextureFileName(ResourceLocation fileLocation) {
        String path = fileLocation.m_135815_();
        String[] splitPath = path.split("/");
        String suffixedName = splitPath[splitPath.length - 1];
        return suffixedName.substring(0, suffixedName.length() - ".png".length());
    }

    public SpriteSourceType m_260850_() {
        return SpriteSourceTypes.ALPHA_MASK_FOLDER_PERMUTATIONS;
    }

    @OnlyIn(value=Dist.CLIENT)
    record MaskedSpriteSupplier(NativeImage baseNative, LazyLoadedImage maskImage, ResourceLocation permutationLocation) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public SpriteContents get() {
            try {
                int width = this.baseNative.m_84982_();
                int height = this.baseNative.m_85084_();
                NativeImage nativeimage = new NativeImage(width, height, false);
                NativeImage alphaMaskNative = this.maskImage.m_266167_();
                for (int chWidth = 0; chWidth < width; ++chWidth) {
                    for (int chHeight = 0; chHeight < height; ++chHeight) {
                        if (FastColor.ABGR32.m_266503_((int)alphaMaskNative.m_84985_(chWidth, chHeight)) != 0) {
                            nativeimage.m_84988_(chWidth, chHeight, this.baseNative.m_84985_(chWidth, chHeight));
                            continue;
                        }
                        nativeimage.m_84988_(chWidth, chHeight, alphaMaskNative.m_84985_(chWidth, chHeight));
                    }
                }
                SpriteContents spriteContents = new SpriteContents(this.permutationLocation, new FrameSize(nativeimage.m_84982_(), nativeimage.m_85084_()), nativeimage, AnimationMetadataSection.f_119012_, ForgeTextureMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException ioexception) {
                LOGGER.error("unable to apply alpha mask to {}", (Object)this.permutationLocation, (Object)ioexception);
            }
            finally {
                this.maskImage.m_266458_();
            }
            return null;
        }

        public void m_260986_() {
            this.maskImage.m_266458_();
        }
    }
}

