/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.client.renderer.gui.screen.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.userofbricks.expanded_combat.ExpandedCombat;
import com.userofbricks.expanded_combat.config.OverlayAnchorPoss;
import com.userofbricks.expanded_combat.item.ECQuiverItem;
import com.userofbricks.expanded_combat.network.ECVariables;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class QuiverSlotOverlay {
    protected static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void overlayEventHandler(RenderGuiEvent.Pre event) {
        ItemStack currentArrow;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        Optional quiverSlotResult = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> stack.m_41720_() instanceof ECQuiverItem);
        if (quiverSlotResult.isEmpty()) {
            return;
        }
        if (!(player.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof BowItem)) {
            return;
        }
        int w = event.getWindow().m_85445_();
        int h = event.getWindow().m_85446_();
        ECQuiverItem quiver = (ECQuiverItem)((SlotResult)quiverSlotResult.get()).stack().m_41720_();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int providedSlots = quiver.providedSlots;
        int currentIndex = ECVariables.getArrowSlot((Entity)player);
        int beforeIndex = currentIndex - 1 < 0 ? providedSlots - 1 : currentIndex - 1;
        int nextIndex = currentIndex + 1 >= providedSlots ? 0 : currentIndex + 1;
        ItemStack nextArrow = null;
        ItemStack beforeArrow = null;
        Optional currentSelectedSlotResult = CuriosApi.getCuriosHelper().findCurio((LivingEntity)player, "arrows", currentIndex);
        if (currentSelectedSlotResult.isEmpty()) {
            currentSelectedSlotResult = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(ItemTags.f_13161_).contains((Object)stack.m_41720_()));
        }
        if (!(currentArrow = currentSelectedSlotResult.isEmpty() ? ItemStack.f_41583_ : ((SlotResult)currentSelectedSlotResult.get()).stack()).m_41619_()) {
            int slot = beforeIndex;
            while (true) {
                int n = slot = slot < 0 ? providedSlots - 1 : slot;
                if (slot == currentIndex) break;
                Optional beforeSelectedSlotResult = CuriosApi.getCuriosHelper().findCurio((LivingEntity)player, "arrows", slot);
                if (beforeSelectedSlotResult.isPresent()) {
                    beforeArrow = ((SlotResult)beforeSelectedSlotResult.get()).stack();
                    break;
                }
                --slot;
            }
            slot = nextIndex;
            while (true) {
                int n = slot = slot >= providedSlots ? 0 : slot;
                if (slot == currentIndex) break;
                Optional nextSelectedSlotResult = CuriosApi.getCuriosHelper().findCurio((LivingEntity)player, "arrows", slot);
                if (nextSelectedSlotResult.isPresent()) {
                    nextArrow = ((SlotResult)nextSelectedSlotResult.get()).stack();
                    break;
                }
                ++slot;
            }
        }
        beforeArrow = beforeArrow == null ? ItemStack.f_41583_ : beforeArrow;
        nextArrow = nextArrow == null ? ItemStack.f_41583_ : nextArrow;
        int offsetX = ExpandedCombat.CONFIG.quiverHudAnchor.xAxisRatio.apply(w) + ExpandedCombat.CONFIG.quiverHudXAdjustment;
        int offsetY = ExpandedCombat.CONFIG.quiverHudAnchor.yAxisRatio.apply(h) + ExpandedCombat.CONFIG.quiverHudYAdjustment;
        if (!player.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
            if (player.m_5737_().m_20828_() == HumanoidArm.LEFT && ExpandedCombat.CONFIG.quiverHudAnchor == OverlayAnchorPoss.LEFT_OF_HOTBAR) {
                offsetX -= 29;
            } else if (player.m_5737_().m_20828_() == HumanoidArm.RIGHT && ExpandedCombat.CONFIG.quiverHudAnchor == OverlayAnchorPoss.RIGHT_OF_HOTBAR) {
                offsetX += 29;
            }
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -90.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS_LOCATION);
        guiGraphics.m_280218_(WIDGETS_LOCATION, offsetX, offsetY, 24, 23, 22, 22);
        guiGraphics.m_280168_().m_85849_();
        QuiverSlotOverlay.renderSlot(guiGraphics, offsetX + 3, offsetY + 3, event.getPartialTick(), (Player)player, currentArrow);
        QuiverSlotOverlay.renderSlot(guiGraphics, offsetX - 17, offsetY + 3, event.getPartialTick(), (Player)player, beforeArrow);
        QuiverSlotOverlay.renderSlot(guiGraphics, offsetX + 20, offsetY + 3, event.getPartialTick(), (Player)player, nextArrow);
    }

    private static void renderSlot(GuiGraphics guiGraphics, int x, int y, float particleTick, Player player, ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            float f = (float)itemStack.m_41612_() - particleTick;
            if (f > 0.0f) {
                float f1 = 1.0f + f / 5.0f;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)(x + 8), (float)(y + 12), 0.0f);
                guiGraphics.m_280168_().m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                guiGraphics.m_280168_().m_252880_((float)(-(x + 8)), (float)(-(y + 12)), 0.0f);
            }
            guiGraphics.m_280638_((LivingEntity)player, itemStack, x, y, 0);
            if (f > 0.0f) {
                guiGraphics.m_280168_().m_85849_();
            }
            guiGraphics.m_280370_(Minecraft.m_91087_().f_91062_, itemStack, x, y);
        }
    }
}

