/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.userofbricks.expanded_combat.client.model.QuiverModel;
import com.userofbricks.expanded_combat.init.ECLayerDefinitions;
import com.userofbricks.expanded_combat.item.ECQuiverItem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class QuiverRenderer
implements ICurioRenderer {
    private final QuiverModel model = new QuiverModel(Minecraft.m_91087_().m_167973_().m_171103_(ECLayerDefinitions.QUIVER));

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (stack.m_41720_() instanceof ECQuiverItem) {
            ResourceLocation QUIVER_TEXTURE = ((ECQuiverItem)stack.m_41720_()).getQUIVER_TEXTURE();
            LivingEntity entity = slotContext.entity();
            this.model.m_6839_((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ICurioRenderer.translateIfSneaking((PoseStack)poseStack, (LivingEntity)entity);
            ICurioRenderer.rotateIfSneaking((PoseStack)poseStack, (LivingEntity)entity);
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)QUIVER_TEXTURE), (boolean)false, (boolean)stack.m_41790_());
            this.model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)Minecraft.m_91087_().f_91074_).ifPresent(curios -> {
                IDynamicStackHandler stackHandler = ((ICurioStacksHandler)curios.getCurios().get("arrows")).getStacks();
                ItemStack quiverStack = ((ICurioStacksHandler)curios.getCurios().get("quiver_ec")).getStacks().getStackInSlot(0);
                Item patt3497$temp = quiverStack.m_41720_();
                if (patt3497$temp instanceof ECQuiverItem) {
                    ECQuiverItem ecQuiverItem = (ECQuiverItem)patt3497$temp;
                    ArrayList<Integer> nonEmptySlots = QuiverRenderer.getRedstoneSignalFromContainer((IItemHandler)stackHandler);
                    if (!nonEmptySlots.isEmpty()) {
                        boolean notOneSlot = ecQuiverItem.providedSlots > 1;
                        int thirdOfCapacity = Math.max(1, notOneSlot ? Math.round((float)ecQuiverItem.providedSlots / 3.0f) : Math.round((float)Math.min(stackHandler.getSlotLimit(0), stackHandler.getStackInSlot(0).m_41741_()) / 3.0f));
                        Minecraft mc = Minecraft.m_91087_();
                        assert (mc.f_91074_ != null);
                        poseStack.m_85836_();
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                        poseStack.m_85837_(0.109375, -0.296875, (double)-0.25625f);
                        mc.m_91290_().m_234586_().m_269530_((LivingEntity)mc.f_91074_, stackHandler.getStackInSlot(nonEmptySlots.get(0).intValue()), ItemDisplayContext.THIRD_PERSON_LEFT_HAND, false, poseStack, multiBufferSource, light);
                        if ((notOneSlot ? nonEmptySlots.size() : stackHandler.getStackInSlot(0).m_41613_()) >= thirdOfCapacity) {
                            poseStack.m_85837_(0.078125, -0.078125, -0.015625);
                            mc.m_91290_().m_234586_().m_269530_((LivingEntity)mc.f_91074_, stackHandler.getStackInSlot(notOneSlot ? nonEmptySlots.get(Math.round(thirdOfCapacity - 1)) : 0), ItemDisplayContext.THIRD_PERSON_LEFT_HAND, false, poseStack, multiBufferSource, light);
                        }
                        if ((notOneSlot ? nonEmptySlots.size() : stackHandler.getStackInSlot(0).m_41613_()) >= thirdOfCapacity * 2) {
                            poseStack.m_85837_(-0.046875, 0.046875, -0.03125);
                            mc.m_91290_().m_234586_().m_269530_((LivingEntity)mc.f_91074_, stackHandler.getStackInSlot(notOneSlot ? nonEmptySlots.get(Math.round(thirdOfCapacity * 2 - 1)) : 0), ItemDisplayContext.THIRD_PERSON_LEFT_HAND, false, poseStack, multiBufferSource, light);
                        }
                        poseStack.m_85849_();
                    }
                }
            });
        }
    }

    private static ArrayList<Integer> getRedstoneSignalFromContainer(IItemHandler itemHandler) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (itemHandler == null) {
            return result;
        }
        for (int j = 0; j < itemHandler.getSlots(); ++j) {
            ItemStack itemstack = itemHandler.getStackInSlot(j);
            if (itemstack.m_41619_()) continue;
            result.add(j);
        }
        return result;
    }
}

