/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.userofbricks.expanded_combat.ExpandedCombat;
import com.userofbricks.expanded_combat.api.client.IGauntletRenderer;
import com.userofbricks.expanded_combat.client.model.GauntletModel;
import com.userofbricks.expanded_combat.client.model.MaulersModel;
import com.userofbricks.expanded_combat.init.ECLayerDefinitions;
import com.userofbricks.expanded_combat.item.ECGauntletItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class MaulersRenderer
implements IGauntletRenderer {
    private ResourceLocation GAUNTLET_TEXTURE = ExpandedCombat.modLoc("textures/model/gauntlet/maulers.png");
    private final MaulersModel model = new MaulersModel(Minecraft.m_91087_().m_167973_().m_171103_(ECLayerDefinitions.MAULERS));

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Item item = stack.m_41720_();
        if (item instanceof ECGauntletItem) {
            ECGauntletItem ecGauntletItem = (ECGauntletItem)item;
            this.GAUNTLET_TEXTURE = ecGauntletItem.getGauntletTexture(stack);
            LivingEntity entity = slotContext.entity();
            this.model.m_8009_(false);
            this.model.f_102812_.f_104207_ = true;
            this.model.f_102811_.f_104207_ = true;
            this.model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{this.model});
            this.renderModel(poseStack, multiBufferSource, light, stack.m_41790_(), (Model)this.model, 1.0f, 1.0f, 1.0f, this.GAUNTLET_TEXTURE);
        }
    }

    @Override
    public void renderFirstPersonArm(ItemStack stack, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, HumanoidArm arm, boolean hasFoil) {
        if (!player.m_5833_()) {
            ModelPart modelPart = arm == HumanoidArm.LEFT ? this.model.f_102812_ : this.model.f_102811_;
            this.model.m_8009_(false);
            modelPart.f_104207_ = true;
            this.model.f_102817_ = false;
            this.model.f_102818_ = 0.0f;
            this.model.f_102608_ = 0.0f;
            this.model.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            modelPart.f_104203_ = 0.0f;
            Item item = stack.m_41720_();
            if (item instanceof ECGauntletItem) {
                ECGauntletItem ecGauntletItem = (ECGauntletItem)item;
                this.GAUNTLET_TEXTURE = ecGauntletItem.getGauntletTexture(stack);
                RenderType renderType = RenderType.m_110431_((ResourceLocation)this.GAUNTLET_TEXTURE);
                VertexConsumer builder = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
                modelPart.m_104301_(poseStack, builder, light, OverlayTexture.f_118083_);
            }
        }
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource multibuffersource, int light, boolean foil, Model model, float f, float f1, float f2, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)multibuffersource, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)foil);
        model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, f, f1, f2, 1.0f);
    }

    private void renderTrim(ECGauntletItem ecGauntletItem, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, ArmorTrim armorTrim, boolean foil) {
        Object materialSuffix = ((TrimMaterial)armorTrim.m_266210_().get()).f_265854_();
        if (((String)materialSuffix).equals(ecGauntletItem.getMaterial().getLocationName())) {
            materialSuffix = (String)materialSuffix + "_darker";
        }
        ResourceLocation trimTexture = new ResourceLocation("expanded_combat", "trims/models/gauntlets/" + ((TrimPattern)armorTrim.m_266429_().get()).f_266052_().m_135815_() + "_" + (String)materialSuffix);
        TextureAtlasSprite textureatlassprite = Minecraft.m_91087_().m_91304_().m_119428_(Sheets.f_265912_).m_118316_(trimTexture);
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(ItemRenderer.m_115222_((MultiBufferSource)multiBufferSource, (RenderType)Sheets.m_266442_(), (boolean)true, (boolean)foil));
        new GauntletModel(Minecraft.m_91087_().m_167973_().m_171103_(ECLayerDefinitions.GAUNTLET)).m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

