/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.block;

import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class AbstractGasBlock
extends Block {
    private final Supplier<ParticleOptions> particleSupplier;

    public AbstractGasBlock(BlockBehaviour.Properties properties, Supplier<ParticleOptions> particleSupplier) {
        super(properties.m_280170_());
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
        this.particleSupplier = particleSupplier;
    }

    public RenderShape m_7514_(BlockState p_48758_) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState p_48760_, BlockGetter p_48761_, BlockPos p_48762_, CollisionContext p_48763_) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5909_(BlockState p_60479_, BlockGetter p_60480_, BlockPos p_60481_, CollisionContext p_60482_) {
        return Shapes.m_83144_();
    }

    public void m_214162_(BlockState p_221789_, Level p_221790_, BlockPos p_221791_, RandomSource p_221792_) {
        super.m_214162_(p_221789_, p_221790_, p_221791_, p_221792_);
        p_221790_.m_7106_(this.particleSupplier.get(), (double)p_221791_.m_123341_() + p_221792_.m_188500_(), (double)p_221791_.m_123342_() + p_221792_.m_188500_(), (double)p_221791_.m_123343_() + p_221792_.m_188500_(), 0.0, 0.0, 0.0);
        p_221790_.m_7106_(this.particleSupplier.get(), (double)p_221791_.m_123341_() + p_221792_.m_188500_(), (double)p_221791_.m_123342_() + p_221792_.m_188500_(), (double)p_221791_.m_123343_() + p_221792_.m_188500_(), 0.0, 0.0, 0.0);
        p_221790_.m_7106_(this.particleSupplier.get(), (double)p_221791_.m_123341_() + p_221792_.m_188500_(), (double)p_221791_.m_123342_() + p_221792_.m_188500_(), (double)p_221791_.m_123343_() + p_221792_.m_188500_(), 0.0, 0.0, 0.0);
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 5);
    }

    public void m_213897_(BlockState blockState, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(blockState, world, pos, random);
        BlockPos randPos = pos.m_121945_((Direction)Util.m_214621_(Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST), (RandomSource)random));
        if (random.m_188503_(3) == 0) {
            if (world.m_8055_(pos.m_7494_()).m_60795_() && pos.m_123342_() < world.m_151558_() - 1) {
                world.m_46597_(pos.m_7494_(), this.m_49966_());
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                world.m_186460_(pos, (Block)this, 5);
                return;
            }
            if (world.m_8055_(randPos).m_60795_() && pos.m_123342_() < world.m_151558_() - 1 && this.isAirNear((Level)world, randPos.m_7494_())) {
                world.m_46597_(randPos, this.m_49966_());
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                world.m_186460_(pos, (Block)this, 5);
                return;
            }
        }
        if (random.m_188503_(500) == 0) {
            BlockPos randPos1 = pos.m_121945_((Direction)Util.m_214670_((Object[])Direction.values(), (RandomSource)random));
            if (this.blockCatalistItemConversions(blockState, world.m_8055_(randPos), world, pos, randPos1, random)) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                return;
            }
        }
        world.m_186460_(pos, (Block)this, 5);
    }

    public abstract boolean blockCatalistItemConversions(BlockState var1, BlockState var2, ServerLevel var3, BlockPos var4, BlockPos var5, RandomSource var6);

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        level.m_186460_(pos, (Block)this, 1);
        super.m_6861_(state, level, pos, block, pos1, b);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockPos randPos;
        if (level instanceof ServerLevel && level.m_8055_(randPos = pos.m_121945_((Direction)Util.m_214621_(Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST), (RandomSource)level.f_46441_))).m_60795_() && pos.m_123342_() < level.m_151558_() - 1 && this.isAirNear(level, randPos)) {
            level.m_46597_(randPos, this.m_49966_());
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        super.m_7892_(state, level, pos, entity);
    }

    private boolean isAirNear(Level world, BlockPos randPos) {
        for (int x = -3; x < 3; ++x) {
            for (int z = -3; z < 3; ++z) {
                if (!world.m_8055_(randPos.m_7918_(x, 0, z)).m_60795_()) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockHitResult getPlayerPOVHitResult(Level level, Player player, ClipContext.Fluid fluid) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3 = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.getBlockReach();
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.VISUAL, fluid, (Entity)player));
    }
}

