/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.registry.itemGeneration;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.userofbricks.expanded_combat.api.NonNullQuadConsumer;
import com.userofbricks.expanded_combat.api.NonNullTriConsumer;
import com.userofbricks.expanded_combat.api.NonNullTriFunction;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.MaterialBuilder;
import com.userofbricks.expanded_combat.api.material.WeaponMaterial;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.MaterialItemBuilder;
import com.userofbricks.expanded_combat.item.ECItemTags;
import com.userofbricks.expanded_combat.item.recipes.builders.RecipeIngredientMapBuilder;
import com.userofbricks.expanded_combat.item.recipes.conditions.ECConfigBooleanCondition;
import com.userofbricks.expanded_combat.plugins.VanillaECPlugin;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.Collections;
import java.util.Map;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WeaponItemBuilder
extends MaterialItemBuilder {
    public final WeaponMaterial weapon;
    public final Material material;
    public final Material craftedFrom;
    public final ItemBuilder<? extends Item, Registrate> itemBuilder;
    public final MaterialBuilder materialBuilder;
    private String lang;
    private NonNullQuadConsumer<DataGenContext<Item, ? extends Item>, RegistrateItemModelProvider, Material, WeaponMaterial> modelBuilder;
    private NonNullQuadConsumer<ItemBuilder<? extends Item, Registrate>, WeaponMaterial, Material, @Nullable Material> recipeBuilder;
    private NonNullTriConsumer<ItemBuilder<? extends Item, Registrate>, WeaponMaterial, Material> colorBuilder;

    public WeaponItemBuilder(MaterialBuilder materialBuilder, Registrate registrate, WeaponMaterial weapon, Material material, Material craftedFrom, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> constructor, boolean shaped) {
        String locationName = material.getLocationName().m_135815_() + "_" + weapon.getLocationName();
        ItemBuilder itemBuilder = registrate.item(locationName, p -> (Item)constructor.apply(material, weapon, (Item.Properties)p));
        if (weapon.potionDippable()) {
            itemBuilder.tag(new TagKey[]{ECItemTags.POTION_WEAPONS});
        }
        this.weapon = weapon;
        this.material = material;
        this.itemBuilder = itemBuilder;
        this.materialBuilder = materialBuilder;
        this.craftedFrom = craftedFrom;
        this.lang = material.getName() + " " + weapon.name();
        this.modelBuilder = WeaponItemBuilder::generateModel;
        this.recipeBuilder = shaped ? WeaponItemBuilder::generateShapedRecipes : WeaponItemBuilder::generateSmithingRecipes;
        this.colorBuilder = (i, w, m) -> WeaponItemBuilder.weaponColors((ItemBuilder<? extends Item, Registrate>)i, w);
    }

    public WeaponItemBuilder lang(String englishName) {
        this.lang = englishName;
        return this;
    }

    public WeaponItemBuilder model(NonNullQuadConsumer<DataGenContext<Item, ? extends Item>, RegistrateItemModelProvider, Material, WeaponMaterial> modelBuilder) {
        this.modelBuilder = modelBuilder;
        return this;
    }

    public WeaponItemBuilder recipes(NonNullQuadConsumer<ItemBuilder<? extends Item, Registrate>, WeaponMaterial, Material, Material> recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
        return this;
    }

    public WeaponItemBuilder colors(NonNullTriConsumer<ItemBuilder<? extends Item, Registrate>, WeaponMaterial, Material> colorBuilder) {
        this.colorBuilder = colorBuilder;
        return this;
    }

    public MaterialBuilder build() {
        this.itemBuilder.lang(this.lang);
        this.itemBuilder.model((ctx, prov) -> this.modelBuilder.apply((DataGenContext<Item, ? extends Item>)ctx, (RegistrateItemModelProvider)prov, this.material, this.weapon));
        this.recipeBuilder.apply(this.itemBuilder, this.weapon, this.material, this.craftedFrom);
        this.colorBuilder.apply(this.itemBuilder, this.weapon, this.material);
        this.materialBuilder.weapon(this.weapon, (NonNullFunction<Material, RegistryEntry<? extends Item>>)((NonNullFunction)m -> this.itemBuilder.register()));
        return this.materialBuilder;
    }

    public static void weaponColors(ItemBuilder<? extends Item, Registrate> itemBuilder, WeaponMaterial weapon) {
        if (weapon.dyeable()) {
            itemBuilder.color(() -> () -> (stack, itemLayer) -> itemLayer > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack));
        } else if (weapon.potionDippable()) {
            itemBuilder.color(() -> () -> (stack, itemLayer) -> itemLayer > 0 ? -1 : PotionUtils.m_43575_((ItemStack)stack));
        }
    }

    public static void generateShapedRecipes(ItemBuilder<? extends Item, Registrate> itemBuilder, WeaponMaterial weapon, Material material, Material craftedFrom) {
        itemBuilder.recipe((ctx, prov) -> {
            boolean useCraftingItem;
            Ingredient craftingIngredient = null;
            InventoryChangeTrigger.TriggerInstance triggerInstance = null;
            boolean bl = useCraftingItem = !material.getConfig().crafting.craftingItem.isEmpty();
            if (useCraftingItem) {
                craftingIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.craftingItem))});
                triggerInstance = WeaponItemBuilder.getTriggerInstance(Collections.singletonList(material.getConfig().crafting.craftingItem));
            } else if (!material.getConfig().crafting.repairItem.isEmpty()) {
                craftingIngredient = IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem);
                triggerInstance = WeaponItemBuilder.getTriggerInstance(material.getConfig().crafting.repairItem);
            }
            if (craftingIngredient != null) {
                ECConfigBooleanCondition enableArrows = new ECConfigBooleanCondition("weapon");
                Map<Character, Ingredient> ingredientMap = new RecipeIngredientMapBuilder().put(Character.valueOf('i'), craftingIngredient).build();
                if (weapon.recipeIngredients() != null) {
                    if (!weapon.recipeContains("i")) {
                        ingredientMap.remove(Character.valueOf('i'));
                    }
                    ingredientMap.putAll(weapon.recipeIngredients().get().build());
                    if (ingredientMap.get(Character.valueOf('p')) == null && weapon.recipeContains("p")) {
                        Ingredient prev = weapon.craftedFrom() == null ? IngredientUtil.getTagedIngredientOrEmpty("forge", "tools/swords/" + material.getLocationName().m_135815_()) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)material.getWeaponEntry(weapon.craftedFrom().name()).get()});
                        ingredientMap.put(Character.valueOf('p'), prev);
                    }
                    if (ingredientMap.get(Character.valueOf('b')) == null && weapon.recipeContains("b")) {
                        ingredientMap.put(Character.valueOf('b'), IngredientUtil.getTagedIngredientOrEmpty("forge", "storage_blocks/" + material.getLocationName().m_135815_()));
                    }
                    WeaponItemBuilder.conditionalShapedRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, weapon.recipe(), ingredientMap, 1, new ICondition[]{enableArrows}, triggerInstance, "");
                }
            }
        });
    }

    public static void generateSmithingRecipes(ItemBuilder<? extends Item, Registrate> itemBuilder, WeaponMaterial weapon, Material material, Material craftedFrom) {
        itemBuilder.recipe((ctx, prov) -> {
            ECConfigBooleanCondition enableWeapons = new ECConfigBooleanCondition("weapon");
            if (craftedFrom != null) {
                WeaponItemBuilder.conditionalSmithing120Recipe((DataGenContext<Item, ? extends Item>)ctx, prov, material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getWeaponEntry(weapon.name()).get()}), new ICondition[]{enableWeapons}, "");
            }
        });
    }

    public static void generateModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov, Material material, WeaponMaterial weapon) {
        WeaponItemBuilder.generateModel(ctx, prov, material, weapon, false, "", "");
    }

    public static void generateModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov, Material material, WeaponMaterial weapon, boolean customTexture, String customHandleTex, String customDyeTex) {
        ItemModelBuilder mainModelBuilder = WeaponItemBuilder.generateModel(ctx, prov, weapon, material, "", customTexture, customHandleTex, customDyeTex);
        if (weapon == VanillaECPlugin.KATANA) {
            mainModelBuilder.override().predicate(new ResourceLocation("blocking"), 1.0f).predicate(new ResourceLocation("blocked_recently"), 1.0f).predicate(new ResourceLocation("block_pos"), 0.1f).model((ModelFile)WeaponItemBuilder.generateModel(ctx, prov, weapon, material, "block_1", customTexture, customHandleTex, customDyeTex)).end();
            mainModelBuilder.override().predicate(new ResourceLocation("blocking"), 1.0f).predicate(new ResourceLocation("blocked_recently"), 1.0f).predicate(new ResourceLocation("block_pos"), 0.2f).model((ModelFile)WeaponItemBuilder.generateModel(ctx, prov, weapon, material, "block_2", customTexture, customHandleTex, customDyeTex)).end();
            mainModelBuilder.override().predicate(new ResourceLocation("blocking"), 1.0f).predicate(new ResourceLocation("blocked_recently"), 1.0f).predicate(new ResourceLocation("block_pos"), 0.3f).model((ModelFile)WeaponItemBuilder.generateModel(ctx, prov, weapon, material, "block_3", customTexture, customHandleTex, customDyeTex)).end();
            mainModelBuilder.override().predicate(new ResourceLocation("blocking"), 1.0f).predicate(new ResourceLocation("blocked_recently"), 1.0f).predicate(new ResourceLocation("block_pos"), 0.4f).model((ModelFile)WeaponItemBuilder.generateModel(ctx, prov, weapon, material, "none", customTexture, customHandleTex, customDyeTex)).end();
        }
    }

    public static ItemModelBuilder generateModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov, WeaponMaterial weapon, Material material, String baseModelSuffix) {
        return WeaponItemBuilder.generateModel(ctx, prov, weapon, material, baseModelSuffix, false, "", "");
    }

    public static ItemModelBuilder generateModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov, WeaponMaterial weapon, Material material, String baseModelSuffix, boolean customTexture, String customHandleTex, String customDyeTex) {
        if (weapon.hasLargeModel() && !weapon.isBlockWeapon()) {
            SeparateTransformsModelBuilder modelFileBuilder = (SeparateTransformsModelBuilder)((ItemModelBuilder)((ItemModelBuilder)prov.getBuilder(!baseModelSuffix.isBlank() ? "item/non_gui_model_predicates/" + ctx.getName() + "_" + baseModelSuffix : "item/" + ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).customLoader(SeparateTransformsModelBuilder::begin);
            modelFileBuilder.base((ModelBuilder)WeaponItemBuilder.generateModel(ctx, prov, weapon, material, "item_large/", "base/" + (String)(!baseModelSuffix.isBlank() ? baseModelSuffix + "/" : ""), !baseModelSuffix.isBlank() ? baseModelSuffix : "", customTexture, customHandleTex, customDyeTex));
            ItemModelBuilder guiModel = WeaponItemBuilder.generateModel(ctx, prov, weapon, material, "item/", "gui/", "", customTexture, customHandleTex, customDyeTex);
            modelFileBuilder.perspective(ItemDisplayContext.GUI, (ModelBuilder)guiModel);
            modelFileBuilder.perspective(ItemDisplayContext.GROUND, (ModelBuilder)guiModel);
            modelFileBuilder.perspective(ItemDisplayContext.FIXED, (ModelBuilder)guiModel);
            return (ItemModelBuilder)modelFileBuilder.end();
        }
        if (!weapon.hasLargeModel() && weapon.isBlockWeapon()) {
            return (ItemModelBuilder)WeaponItemBuilder.getItemBaseModel(prov, weapon, ctx, "", "").texture("head", WeaponItemBuilder.getWeaponTexture(prov, weapon.getLocationName(), material.getLocationName().m_135815_()));
        }
        return WeaponItemBuilder.generateModel(ctx, prov, weapon, material, "item/", "", "", customTexture, customHandleTex, customDyeTex);
    }

    public static ItemModelBuilder generateModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov, WeaponMaterial weapon, Material material, String directory, String returningModelfolder, String parentSuffix, boolean customTexture) {
        return WeaponItemBuilder.generateModel(ctx, prov, weapon, material, directory, returningModelfolder, parentSuffix, customTexture, "", "");
    }

    public static ItemModelBuilder generateModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov, WeaponMaterial weapon, Material material, String directory, String returningModelfolder, String parentSuffix, boolean customTexture, String customHandleTex, String customDyeTex) {
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((ItemModelBuilder)prov.getBuilder("item/" + returningModelfolder + ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        if (weapon.hasCustomTransforms() || weapon.hasLargeModel() && directory.equals("item_large/")) {
            itemModelBuilder = WeaponItemBuilder.getItemBaseModel(prov, weapon, ctx, returningModelfolder, parentSuffix);
        }
        if (customTexture) {
            itemModelBuilder.texture("layer0", new ResourceLocation(ctx.getId().m_135827_(), directory + weapon.getLocationName() + "/" + material.getLocationName().m_135815_()));
        } else if (!weapon.dyeable() && !weapon.potionDippable()) {
            itemModelBuilder.texture("layer0", !customHandleTex.isEmpty() ? new ResourceLocation(ctx.getId().m_135827_(), directory + weapon.getLocationName() + "/" + customHandleTex) : new ResourceLocation("expanded_combat", directory + weapon.getLocationName() + "_handle"));
            itemModelBuilder.texture("layer1", new ResourceLocation(ctx.getId().m_135827_(), directory + weapon.getLocationName() + "/" + material.getLocationName().m_135815_()));
        } else {
            itemModelBuilder.texture("layer0", !customDyeTex.isEmpty() ? new ResourceLocation(ctx.getId().m_135827_(), directory + weapon.getLocationName() + "/" + customDyeTex) : new ResourceLocation("expanded_combat", directory + weapon.getLocationName() + "_dye"));
            itemModelBuilder.texture("layer1", !customHandleTex.isEmpty() ? new ResourceLocation(ctx.getId().m_135827_(), directory + weapon.getLocationName() + "/" + customHandleTex) : new ResourceLocation("expanded_combat", directory + weapon.getLocationName() + "_handle"));
            itemModelBuilder.texture("layer2", new ResourceLocation(ctx.getId().m_135827_(), directory + weapon.getLocationName() + "/" + material.getLocationName().m_135815_()));
        }
        return itemModelBuilder;
    }

    public static ItemModelBuilder getItemBaseModel(RegistrateItemModelProvider prov, WeaponMaterial weapon, DataGenContext<Item, ? extends Item> ctx, String returningModelfolder, String parentSuffix) {
        return (ItemModelBuilder)prov.withExistingParent("item/" + returningModelfolder + ctx.getName(), new ResourceLocation("expanded_combat", "item/bases/" + weapon.getLocationName() + (String)(!parentSuffix.isBlank() ? "_" + parentSuffix : "")));
    }

    private static ResourceLocation getWeaponTexture(RegistrateItemModelProvider prov, String weaponLocation, String textureName) {
        return prov.modLoc("item/" + weaponLocation + "/" + textureName);
    }
}

