/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.registry.itemGeneration;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.item.recipes.builders.FletchingRecipeBuilder;
import com.userofbricks.expanded_combat.item.recipes.builders.SmithingTransformWithoutTemplateRecipeBuilder;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class MaterialItemBuilder {
    public static InventoryChangeTrigger.TriggerInstance getTriggerInstance(List<String> locations) {
        return InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])IngredientUtil.toItemLikeArray(locations));
    }

    public static Advancement.Builder getAdvancement(InventoryChangeTrigger.TriggerInstance triggerInstance, DataGenContext<Item, ? extends Item> ctx) {
        return Advancement.Builder.m_138353_().m_138386_("has_item", (CriterionTriggerInstance)triggerInstance).m_138396_(RecipeBuilder.f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)ctx.getId())).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)ctx.getId())).m_138360_(RequirementsStrategy.f_15979_);
    }

    public static void conditionalShapedRecipe(DataGenContext<Item, ? extends Item> ctx, RegistrateRecipeProvider prov, String[] pattern, Map<Character, Ingredient> definitions, int count, ICondition[] conditions, InventoryChangeTrigger.TriggerInstance triggerInstance, String nameSufix) {
        ConditionalRecipe.Builder conditionalRecipe = MaterialItemBuilder.createConditionalBuilder(ctx, conditions, triggerInstance, "_shaped" + nameSufix);
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get()), (int)count);
        for (String string : pattern) {
            builder.m_126130_(string);
        }
        definitions.forEach((arg_0, arg_1) -> ((ShapedRecipeBuilder)builder).m_126124_(arg_0, arg_1));
        builder.m_126132_("has_item", (CriterionTriggerInstance)triggerInstance);
        builder.m_176500_(arg_0 -> ((ConditionalRecipe.Builder)conditionalRecipe).addRecipe(arg_0), ctx.getId() + "_shaped" + nameSufix);
        conditionalRecipe.build((Consumer)prov, ctx.getId().m_266382_("_shaped" + nameSufix));
    }

    public static void conditionalSmithing120Recipe(DataGenContext<Item, ? extends Item> ctx, RegistrateRecipeProvider prov, Material material, Ingredient previosItem, ICondition[] conditions, String nameSufix) {
        boolean useCraftingItem;
        Ingredient craftingIngredient = null;
        InventoryChangeTrigger.TriggerInstance triggerInstance = null;
        boolean bl = useCraftingItem = !material.getConfig().crafting.craftingItem.isEmpty();
        if (useCraftingItem) {
            craftingIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.craftingItem))});
            triggerInstance = MaterialItemBuilder.getTriggerInstance(Collections.singletonList(material.getConfig().crafting.craftingItem));
        } else if (!material.getConfig().crafting.repairItem.isEmpty()) {
            craftingIngredient = IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem);
            triggerInstance = MaterialItemBuilder.getTriggerInstance(material.getConfig().crafting.repairItem);
        }
        if (craftingIngredient != null) {
            if (material.getConfig().crafting.smithingTemplate != null && !material.getConfig().crafting.smithingTemplate.equals("minecraft:air")) {
                MaterialItemBuilder.conditionalSmithing120Recipe(ctx, prov, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.smithingTemplate))}), craftingIngredient, previosItem, conditions, triggerInstance, nameSufix);
            } else {
                MaterialItemBuilder.conditionalSmithingWithoutTemplateRecipe(ctx, prov, craftingIngredient, previosItem, conditions, triggerInstance, nameSufix);
            }
        }
    }

    public static void conditionalSmithing120Recipe(DataGenContext<Item, ? extends Item> ctx, RegistrateRecipeProvider prov, Ingredient template, Ingredient ingredient, Ingredient previosItem, ICondition[] conditions, InventoryChangeTrigger.TriggerInstance triggerInstance, String nameSufix) {
        ConditionalRecipe.Builder conditionalRecipe = MaterialItemBuilder.createConditionalBuilder(ctx, conditions, triggerInstance, "_120_smithing" + nameSufix);
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)template, (Ingredient)previosItem, (Ingredient)ingredient, (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)ctx.get())).m_266439_("has_item", (CriterionTriggerInstance)triggerInstance).m_266260_(arg_0 -> ((ConditionalRecipe.Builder)conditionalRecipe).addRecipe(arg_0), ctx.getId() + "_120_smithing" + nameSufix);
        conditionalRecipe.build((Consumer)prov, ctx.getId().m_266382_("_120_smithing" + nameSufix));
    }

    public static void conditionalSmithingWithoutTemplateRecipe(DataGenContext<Item, ? extends Item> ctx, RegistrateRecipeProvider prov, Ingredient ingredient, Ingredient previosItem, ICondition[] conditions, InventoryChangeTrigger.TriggerInstance triggerInstance, String nameSufix) {
        ConditionalRecipe.Builder conditionalRecipe = MaterialItemBuilder.createConditionalBuilder(ctx, conditions, triggerInstance, "_120_smithing" + nameSufix);
        SmithingTransformWithoutTemplateRecipeBuilder.smithing(previosItem, ingredient, RecipeCategory.COMBAT, (Item)ctx.get()).unlocks("has_item", (CriterionTriggerInstance)triggerInstance).save(arg_0 -> ((ConditionalRecipe.Builder)conditionalRecipe).addRecipe(arg_0), ctx.getId() + "_120_smithing" + nameSufix);
        conditionalRecipe.build((Consumer)prov, ctx.getId().m_266382_("_120_smithing" + nameSufix));
    }

    public static void conditionalFletchingRecipe(DataGenContext<Item, ? extends Item> ctx, RegistrateRecipeProvider prov, Ingredient addition, Ingredient previosItem, ICondition[] conditions, InventoryChangeTrigger.TriggerInstance triggerInstance, String nameSufix, int resultCount) {
        ConditionalRecipe.Builder conditionalRecipe = MaterialItemBuilder.createConditionalBuilder(ctx, conditions, triggerInstance, "_fletching" + nameSufix);
        FletchingRecipeBuilder.fletching(previosItem, addition, RecipeCategory.COMBAT, (Item)ctx.get(), resultCount).unlocks("has_item", (CriterionTriggerInstance)triggerInstance).save(arg_0 -> ((ConditionalRecipe.Builder)conditionalRecipe).addRecipe(arg_0), ctx.getId() + "_fletching");
        conditionalRecipe.build((Consumer)prov, ctx.getId().m_266382_("_fletching" + nameSufix));
    }

    public static void conditionalVariableFletchingRecipe(DataGenContext<Item, ? extends Item> ctx, RegistrateRecipeProvider prov, Ingredient addition, Ingredient previosItem, ICondition[] conditions, InventoryChangeTrigger.TriggerInstance triggerInstance, String nameSufix, int maxResultCount) {
        ConditionalRecipe.Builder conditionalRecipe = MaterialItemBuilder.createConditionalBuilder(ctx, conditions, triggerInstance, "_variable_fletching" + nameSufix);
        FletchingRecipeBuilder.fletchingVarableResult(previosItem, addition, RecipeCategory.COMBAT, (Item)ctx.get(), maxResultCount).unlocks("has_item", (CriterionTriggerInstance)triggerInstance).save(arg_0 -> ((ConditionalRecipe.Builder)conditionalRecipe).addRecipe(arg_0), ctx.getId() + "_variable_fletching");
        conditionalRecipe.build((Consumer)prov, ctx.getId().m_266382_("_variable_fletching" + nameSufix));
    }

    private static ConditionalRecipe.Builder createConditionalBuilder(DataGenContext<Item, ? extends Item> ctx, ICondition[] conditions, InventoryChangeTrigger.TriggerInstance triggerInstance, String nameSufix) {
        ConditionalRecipe.Builder conditionalRecipe = ConditionalRecipe.builder();
        ConditionalAdvancement.Builder conditionalAdvancement = ConditionalAdvancement.builder();
        for (ICondition condition : conditions) {
            conditionalRecipe.addCondition(condition);
            conditionalAdvancement.addCondition(condition);
        }
        conditionalRecipe.setAdvancement(ctx.getId().m_135827_(), "recipes/" + RecipeCategory.COMBAT.m_247710_() + "/" + ctx.getId().m_135815_() + "_conditional" + nameSufix, conditionalAdvancement.addAdvancement(MaterialItemBuilder.getAdvancement(triggerInstance, ctx)));
        return conditionalRecipe;
    }
}

